<?php if ( ! defined( 'ABSPATH' ) ) {
	exit( 'No direct script access allowed' );
}
/**
 * Template "Welcome" for 8theme dashboard.
 *
 * @since   6.0.2
 * @version 1.0.0
 */
?>

<?php
$system = new Etheme_System_Requirements();
//    $system->html();
$result       = $system->result();
$is_activated = etheme_is_activated();
$xstore_branding_settings = get_option( 'xstore_white_label_branding_settings', array() );
?>

<?php

$settings                 = array();
$settings['welcome_text'] = 'Welcome to XStore!';

ob_start();
    if ( $is_activated ) : ?>
        <p>Thank you for choosing XStore. We hope you’ll like it!</p>
    <?php else: ?>
        <p>Thank you for choosing XStore. We hope you’ll like it!<br/> To enjoy the full experience we strongly
        recommend to activate a theme with your purchase code.</p>
    <?php endif; ?>

    <svg width="400" height="229" viewBox="0 0 400 229" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M63.2343 175.148C63.0654 175.148 62.902 175.089 62.772 174.981C62.6421 174.873 62.5538 174.724 62.5225 174.558L57.2481 146.679C57.2123 146.49 57.2532 146.294 57.3616 146.135C57.4701 145.976 57.6372 145.867 57.8263 145.831C58.0154 145.795 58.211 145.836 58.3699 145.945C58.5289 146.053 58.6383 146.22 58.674 146.409L63.9484 174.288C63.9662 174.382 63.9653 174.478 63.9458 174.571C63.9264 174.664 63.8888 174.753 63.8352 174.832C63.7815 174.91 63.7129 174.978 63.6332 175.03C63.5536 175.082 63.4644 175.118 63.3708 175.136C63.3258 175.144 63.2801 175.148 63.2343 175.148Z"
              fill="#222433"/>
        <path d="M254.361 215.624C254.184 215.624 254.014 215.56 253.882 215.444L219.402 185.114C219.259 184.987 219.171 184.809 219.158 184.619C219.145 184.428 219.208 184.239 219.333 184.095L283.335 110.174C287.343 105.601 292.962 102.752 299.021 102.222C299.029 102.222 299.038 102.221 299.046 102.22L305.02 101.901C305.212 101.891 305.4 101.957 305.543 102.086C305.686 102.215 305.773 102.395 305.783 102.587C305.793 102.779 305.727 102.967 305.598 103.11C305.469 103.253 305.289 103.339 305.097 103.349L299.137 103.668C293.456 104.168 288.187 106.84 284.427 111.128L220.9 184.5L254.284 213.866L314.706 142.214C314.768 142.142 314.843 142.082 314.927 142.038C315.012 141.994 315.104 141.968 315.199 141.959C315.294 141.951 315.389 141.962 315.48 141.991C315.571 142.02 315.655 142.066 315.728 142.128C315.801 142.189 315.861 142.264 315.904 142.349C315.948 142.433 315.975 142.526 315.983 142.62C315.991 142.715 315.98 142.811 315.952 142.902C315.923 142.992 315.876 143.077 315.815 143.149L254.916 215.366C254.854 215.44 254.778 215.501 254.692 215.545C254.606 215.589 254.512 215.615 254.416 215.622C254.396 215.624 254.378 215.624 254.361 215.624Z"
              fill="#222433"/>
        <path d="M359.268 143.618C359.081 143.618 358.902 143.546 358.767 143.417C358.632 143.289 358.552 143.113 358.544 142.927C358.535 142.74 358.598 142.558 358.721 142.417C358.843 142.277 359.015 142.189 359.2 142.171C369.061 141.24 377.598 134.501 380.947 125.001C380.979 124.911 381.028 124.828 381.091 124.757C381.155 124.687 381.232 124.629 381.318 124.588C381.404 124.547 381.497 124.523 381.592 124.518C381.687 124.513 381.782 124.527 381.872 124.559C381.962 124.59 382.045 124.64 382.115 124.703C382.186 124.767 382.244 124.844 382.285 124.93C382.326 125.016 382.35 125.109 382.355 125.204C382.36 125.299 382.346 125.394 382.314 125.484C378.779 135.514 369.759 142.632 359.337 143.616C359.314 143.617 359.291 143.618 359.268 143.618Z"
              fill="#222433"/>
        <path d="M36.9045 172.973C36.7122 172.973 36.5277 172.897 36.3918 172.761C36.2558 172.625 36.1794 172.44 36.1794 172.248C36.1781 170.974 35.6715 169.753 34.7707 168.852C33.8699 167.951 32.6485 167.445 31.3746 167.443H26.2701C24.9957 167.444 23.7738 167.95 22.8724 168.851C21.9711 169.752 21.4641 170.974 21.4629 172.248C21.4629 172.44 21.3865 172.625 21.2505 172.761C21.1145 172.897 20.9301 172.973 20.7378 172.973C20.5455 172.973 20.3611 172.897 20.2251 172.761C20.0891 172.625 20.0127 172.44 20.0127 172.248C20.0146 170.59 20.6742 169 21.8468 167.827C23.0194 166.655 24.6093 165.995 26.2677 165.993H31.3746C33.0329 165.995 34.6228 166.655 35.7955 167.827C36.9681 169 37.6277 170.59 37.6295 172.248C37.6295 172.44 37.5531 172.625 37.4172 172.761C37.2812 172.897 37.0968 172.973 36.9045 172.973Z"
              fill="#222433"/>
        <path d="M114.166 89.781C114.118 89.7809 114.07 89.7762 114.023 89.7667C112.033 89.3677 110.454 89.0624 108.237 88.7668C108.142 88.7542 108.051 88.7232 107.969 88.6754C107.887 88.6276 107.814 88.5641 107.757 88.4884C107.699 88.4128 107.656 88.3265 107.632 88.2345C107.607 88.1424 107.601 88.0465 107.614 87.9521C107.626 87.8577 107.658 87.7667 107.705 87.6843C107.753 87.6019 107.817 87.5298 107.892 87.4719C107.968 87.4141 108.054 87.3717 108.146 87.3472C108.238 87.3228 108.334 87.3167 108.429 87.3293C110.684 87.6302 112.357 87.9535 114.308 88.3444C114.485 88.3796 114.642 88.4792 114.749 88.6237C114.856 88.7683 114.906 88.9476 114.888 89.1267C114.87 89.3058 114.787 89.4719 114.653 89.5927C114.52 89.7136 114.346 89.7805 114.166 89.7805V89.781Z"
              fill="#222433"/>
        <path d="M142.939 101.873C142.752 101.873 142.571 101.8 142.436 101.67C140.103 99.4222 135.479 96.6609 130.068 94.2813C129.98 94.2437 129.9 94.189 129.833 94.1203C129.766 94.0516 129.713 93.9703 129.678 93.8811C129.642 93.7919 129.625 93.6965 129.627 93.6005C129.628 93.5046 129.649 93.4099 129.688 93.322C129.726 93.2342 129.782 93.1548 129.852 93.0887C129.921 93.0225 130.003 92.9708 130.093 92.9365C130.183 92.9023 130.278 92.8862 130.374 92.8892C130.47 92.8922 130.564 92.9141 130.652 92.9539C136.211 95.3986 140.992 98.2665 143.442 100.625C143.546 100.725 143.618 100.855 143.648 100.996C143.678 101.137 143.666 101.284 143.612 101.419C143.558 101.553 143.465 101.668 143.345 101.748C143.225 101.829 143.084 101.873 142.939 101.873Z"
              fill="#222433"/>
        <path d="M110.288 98.7177C109.536 98.7207 108.786 98.6454 108.049 98.4929C107.861 98.4534 107.696 98.3407 107.591 98.1797C107.486 98.0186 107.449 97.8224 107.489 97.6342C107.528 97.446 107.641 97.2812 107.802 97.1761C107.963 97.071 108.159 97.0342 108.347 97.0737C110.95 97.6204 113.67 96.8985 116.551 96.1343C118.098 95.6968 119.667 95.3379 121.251 95.059C130.601 93.5552 131.817 92.1019 131.967 91.6925C132.066 91.4213 132.005 91.3329 131.982 91.2995C131.409 90.4637 127.466 90.3997 123.988 90.3434C120.892 90.2931 117.383 90.2361 114.066 89.774C113.971 89.7608 113.88 89.7292 113.798 89.681C113.716 89.6328 113.644 89.5688 113.587 89.4929C113.53 89.4169 113.488 89.3303 113.464 89.2382C113.44 89.146 113.434 89.05 113.447 88.9557C113.461 88.8614 113.492 88.7706 113.54 88.6885C113.589 88.6064 113.653 88.5346 113.729 88.4772C113.805 88.4198 113.891 88.3779 113.983 88.354C114.075 88.33 114.171 88.3245 114.266 88.3376C117.496 88.7876 120.957 88.8437 124.012 88.8935C129.379 88.9807 132.225 89.0907 133.178 90.479C133.344 90.729 133.445 91.0168 133.471 91.316C133.498 91.6151 133.449 91.9161 133.329 92.1913C132.929 93.2833 131.266 94.9174 121.481 96.491C119.945 96.7628 118.424 97.1117 116.923 97.5363C114.648 98.1393 112.468 98.7177 110.288 98.7177Z"
              fill="#222433"/>
        <path d="M77.8698 86.9321C77.7025 86.9319 77.5405 86.8739 77.4111 86.7679C77.2818 86.662 77.193 86.5145 77.1599 86.3506L72.9514 65.5454C72.3522 62.5826 70.6174 59.9655 67.9343 57.9774C65.2504 56.0325 62.0635 54.9008 58.754 54.7175C58.0254 54.6739 57.2946 54.682 56.5672 54.7416L53.1777 55.0355C52.9876 55.0495 52.7995 54.9881 52.6544 54.8645C52.5092 54.7409 52.4185 54.5651 52.402 54.3751C52.3855 54.1852 52.4445 53.9964 52.5662 53.8496C52.6879 53.7028 52.8626 53.6099 53.0523 53.5909L56.4454 53.2966C57.2421 53.2314 58.0425 53.2228 58.8405 53.2709C62.4308 53.4719 65.8875 54.7016 68.7982 56.8132C71.7741 59.0183 73.7018 61.9387 74.3732 65.259L78.5818 86.0642C78.6199 86.2527 78.5816 86.4486 78.4752 86.6088C78.3689 86.7691 78.2033 86.8805 78.0148 86.9186C77.967 86.9279 77.9184 86.9324 77.8698 86.9321Z"
              fill="#222433"/>
        <path d="M103.577 101.148L112.278 77.1672C115.254 68.9668 119.871 61.4592 125.846 55.1033L126.915 53.9649H94.0449L93.037 55.0332C87.0327 61.4031 82.3947 68.9338 79.4081 77.1623L74.3568 91.0885C74.3568 91.0885 90.8159 88.0481 98.4115 92.5106C99.9518 93.4155 99.6342 96.3443 89.6865 97.3826C99.3654 99.8394 98.5867 101.288 98.5867 101.288L103.577 101.148Z"
              fill="#EFEBE9"/>
        <path d="M60.3095 228.535C60.1189 228.535 59.936 228.46 59.8003 228.327C59.6646 228.193 59.587 228.011 59.5844 227.82L59.0757 190.835C59.073 190.642 59.1468 190.457 59.2809 190.319C59.415 190.181 59.5984 190.102 59.7907 190.099C59.983 190.097 60.1685 190.171 60.3063 190.305C60.4442 190.439 60.5231 190.622 60.5258 190.815L61.0346 227.8C61.0359 227.895 61.0184 227.99 60.9832 228.078C60.9479 228.167 60.8956 228.248 60.8292 228.316C60.7628 228.384 60.6836 228.439 60.5961 228.476C60.5086 228.514 60.4146 228.534 60.3194 228.535L60.3095 228.535Z"
              fill="#222433"/>
        <path d="M94.6875 228.535C94.5668 228.535 94.4479 228.505 94.3419 228.447L74.7089 217.776L74.9506 227.613C74.953 227.708 74.9365 227.803 74.9022 227.892C74.868 227.981 74.8165 228.062 74.7508 228.131C74.6852 228.2 74.6065 228.255 74.5195 228.294C74.4324 228.332 74.3386 228.354 74.2433 228.356C74.1481 228.358 74.0534 228.342 73.9645 228.308C73.8756 228.273 73.7944 228.222 73.7254 228.156C73.6564 228.09 73.6011 228.012 73.5625 227.925C73.5239 227.838 73.5028 227.744 73.5005 227.649L73.2274 216.557C73.2243 216.43 73.2547 216.305 73.3155 216.193C73.3764 216.081 73.4656 215.987 73.5741 215.921C73.6826 215.855 73.8067 215.818 73.9339 215.815C74.061 215.812 74.1868 215.842 74.2986 215.903L95.0334 227.173C95.1751 227.25 95.2871 227.372 95.3517 227.52C95.4162 227.667 95.4297 227.832 95.3899 227.989C95.3501 228.145 95.2593 228.284 95.132 228.382C95.0046 228.481 94.8479 228.535 94.6866 228.535L94.6875 228.535Z"
              fill="#222433"/>
        <path d="M130.778 228.535C130.761 228.535 130.743 228.535 130.726 228.533C130.534 228.52 130.356 228.431 130.23 228.286C130.104 228.141 130.041 227.952 130.054 227.76C130.497 221.521 126.289 215.434 120.265 213.603C116.596 212.486 113.758 211.192 106.091 207.615C100.971 205.226 97.3984 201.863 95.4728 197.62C95.4335 197.533 95.4116 197.439 95.4085 197.344C95.4053 197.249 95.4209 197.154 95.4544 197.065C95.4879 196.976 95.5386 196.894 95.6037 196.825C95.6687 196.755 95.7468 196.699 95.8335 196.66C95.9203 196.62 96.0139 196.598 96.109 196.595C96.2042 196.592 96.2991 196.608 96.3882 196.641C96.4773 196.675 96.559 196.725 96.6285 196.791C96.698 196.856 96.7541 196.934 96.7934 197.02C98.572 200.94 101.907 204.063 106.705 206.301C114.302 209.846 117.111 211.127 120.687 212.215C127.342 214.239 131.99 220.966 131.501 227.863C131.487 228.045 131.406 228.216 131.271 228.341C131.137 228.466 130.961 228.535 130.778 228.535Z"
              fill="#222433"/>
        <path d="M68.9558 117.765C71.8227 116.598 73.4652 112.026 75.2897 111.062C79.0748 110.047 83.245 112.736 86.3222 113.137C89.3994 113.539 91.0958 114.233 91.4344 111.584C91.773 108.934 82.5059 104.214 82.5059 104.214L89.6631 104.489C99.1335 105.534 98.9229 101.288 98.9229 101.288H115.832C121.893 101.884 127.468 104.863 131.332 109.57C135.195 114.277 137.031 120.325 136.435 126.386C136.319 127.951 135.961 129.49 135.373 130.946L103.091 198.447L55.0506 189.988L66.41 165.242L70.7822 155.709L76.2057 142.837L42.8283 142.791C39.458 142.786 36.1663 141.773 33.3775 139.88C30.5887 137.988 28.4305 135.303 27.1813 132.173C27.1813 132.173 66.0888 118.932 68.9558 117.765Z"
              fill="#F9A825"/>
        <path d="M10.0007 108.995C9.83309 108.995 9.67072 108.936 9.54121 108.83C9.41171 108.724 9.32307 108.576 9.29038 108.411L5.04679 87.1021C4.79518 85.8385 4.79491 84.5379 5.046 83.2742C5.29709 82.0106 5.79461 80.8088 6.51017 79.7375C7.22573 78.6662 8.1453 77.7463 9.21638 77.0304C10.2875 76.3144 11.4891 75.8165 12.7526 75.565C13.0668 75.5024 13.3868 75.4548 13.7049 75.4236C13.896 75.4052 14.0865 75.4634 14.2348 75.5854C14.3831 75.7073 14.4769 75.8831 14.4958 76.0742C14.5146 76.2652 14.4569 76.4559 14.3353 76.6045C14.2138 76.7531 14.0382 76.8474 13.8472 76.8667C13.5763 76.8933 13.3032 76.9339 13.0356 76.9876C10.8611 77.4206 8.94768 78.6996 7.71619 80.5434C6.4847 82.3871 6.03604 84.6445 6.46889 86.819L10.7127 108.128C10.7337 108.234 10.731 108.342 10.7049 108.446C10.6789 108.55 10.63 108.647 10.5619 108.73C10.4938 108.813 10.4081 108.88 10.3111 108.926C10.214 108.972 10.108 108.995 10.0007 108.995V108.995Z"
              fill="#222433"/>
        <path d="M16.9449 143.864C16.7774 143.864 16.615 143.806 16.4855 143.699C16.356 143.593 16.2674 143.445 16.2346 143.281L13.7063 130.585C13.6712 130.398 13.7115 130.204 13.8184 130.046C13.9253 129.888 14.0902 129.778 14.2774 129.741C14.4645 129.703 14.6588 129.741 14.8181 129.846C14.9775 129.952 15.0889 130.115 15.1284 130.302L17.6577 142.997C17.6952 143.186 17.6563 143.382 17.5496 143.542C17.4428 143.702 17.2768 143.812 17.0883 143.85C17.0411 143.859 16.9931 143.864 16.9449 143.864Z"
              fill="#222433"/>
        <path d="M22.4229 133.752C22.1059 133.752 21.7884 133.742 21.4704 133.721C17.6655 133.467 14.1168 131.714 11.6028 128.847C9.08881 125.98 7.81476 122.232 8.06018 118.427C8.06115 118.414 8.06236 118.401 8.06381 118.388L13.2529 74.9034C13.8769 68.9619 15.9009 64.0032 19.1047 60.5712C21.678 57.8159 25.0549 56.0516 28.3689 55.7347C28.4692 55.725 30.4286 55.5544 34.5352 55.1977C34.6307 55.1882 34.7271 55.1978 34.8188 55.2259C34.9105 55.254 34.9958 55.3 35.0696 55.3613C35.1435 55.4225 35.2044 55.4978 35.2489 55.5828C35.2934 55.6678 35.3206 55.7608 35.3289 55.8564C35.3372 55.952 35.3265 56.0482 35.2973 56.1396C35.2682 56.231 35.2212 56.3157 35.159 56.3888C35.0969 56.4619 35.0209 56.522 34.9353 56.5655C34.8498 56.609 34.7565 56.6351 34.6609 56.6423C33.1735 56.7716 28.6478 57.1648 28.5072 57.1783C25.5404 57.4626 22.4997 59.0599 20.1645 61.5609C17.1777 64.7599 15.286 69.4296 14.6941 75.0653L9.50622 118.541C9.37013 120.663 9.7592 122.785 10.639 124.721C11.5188 126.656 12.8621 128.345 14.5502 129.637C16.2382 130.93 18.2188 131.786 20.3168 132.131C22.4147 132.475 24.5652 132.297 26.578 131.613L67.6654 117.498C67.8473 117.435 68.0465 117.448 68.2193 117.532C68.3921 117.617 68.5242 117.766 68.5867 117.948C68.6492 118.13 68.6368 118.329 68.5524 118.502C68.4679 118.675 68.3183 118.807 68.1364 118.87L27.0466 132.984C25.5581 133.493 23.9959 133.752 22.4229 133.752Z"
              fill="#222433"/>
        <path d="M143.146 90.0835C143.018 90.107 142.881 90.0546 142.766 89.9378C142.651 89.8209 142.567 89.6492 142.532 89.4604C142.497 89.2716 142.515 89.0812 142.581 88.931C142.647 88.7809 142.756 88.6833 142.884 88.6598C150.88 87.1905 153.348 78.0289 155.734 69.1666C158.067 60.5037 160.48 51.5457 168.052 50.1545C175.487 48.7881 178.735 44.2572 182.173 39.4603C186.211 33.8268 189.5 28.8403 198.397 19.943C198.525 19.9195 198.662 19.9719 198.777 20.0888C198.892 20.2056 198.976 20.3773 199.011 20.5661C199.046 20.7549 199.028 20.9453 198.962 21.0955C198.896 21.2456 198.787 21.3432 198.659 21.3667C191 29.0256 187.059 34.7817 182.921 40.5545C179.381 45.4936 176.037 50.1596 168.313 51.5789C161.244 52.878 159.025 61.1171 156.675 69.8404C154.202 79.0245 151.644 88.522 143.146 90.0835Z"
              fill="#222433"/>
        <path d="M142.335 101.873C142.142 101.873 141.958 101.796 141.822 101.66C141.686 101.524 141.61 101.34 141.61 101.148V9.59537C141.61 9.40307 141.686 9.21865 141.822 9.08267C141.958 8.94669 142.142 8.8703 142.335 8.8703C142.527 8.8703 142.711 8.94669 142.847 9.08267C142.983 9.21865 143.06 9.40307 143.06 9.59537V101.148C143.06 101.34 142.983 101.524 142.847 101.66C142.711 101.796 142.527 101.873 142.335 101.873Z"
              fill="#222433"/>
        <path d="M144.839 92.3646H139.814C139.621 92.3646 139.437 92.2882 139.301 92.1522C139.165 92.0163 139.089 91.8318 139.089 91.6395C139.089 91.4472 139.165 91.2628 139.301 91.1268C139.437 90.9908 139.621 90.9145 139.814 90.9145H144.839C145.031 90.9145 145.215 90.9908 145.351 91.1268C145.487 91.2628 145.564 91.4472 145.564 91.6395C145.564 91.8318 145.487 92.0163 145.351 92.1522C145.215 92.2882 145.031 92.3646 144.839 92.3646Z"
              fill="#222433"/>
        <path d="M144.839 80.9471H139.814C139.621 80.9471 139.437 80.8707 139.301 80.7348C139.165 80.5988 139.089 80.4144 139.089 80.222C139.089 80.0297 139.165 79.8453 139.301 79.7094C139.437 79.5734 139.621 79.497 139.814 79.497H144.839C145.031 79.497 145.215 79.5734 145.351 79.7094C145.487 79.8453 145.564 80.0297 145.564 80.222C145.564 80.4144 145.487 80.5988 145.351 80.7348C145.215 80.8707 145.031 80.9471 144.839 80.9471Z"
              fill="#222433"/>
        <path d="M144.839 69.5297H139.814C139.621 69.5297 139.437 69.4533 139.301 69.3174C139.165 69.1814 139.089 68.997 139.089 68.8047C139.089 68.6124 139.165 68.4279 139.301 68.292C139.437 68.156 139.621 68.0796 139.814 68.0796H144.839C145.031 68.0796 145.215 68.156 145.351 68.292C145.487 68.4279 145.564 68.6124 145.564 68.8047C145.564 68.997 145.487 69.1814 145.351 69.3174C145.215 69.4533 145.031 69.5297 144.839 69.5297Z"
              fill="#222433"/>
        <path d="M144.839 58.1123H139.814C139.621 58.1123 139.437 58.0359 139.301 57.8999C139.165 57.764 139.089 57.5795 139.089 57.3872C139.089 57.1949 139.165 57.0105 139.301 56.8745C139.437 56.7386 139.621 56.6622 139.814 56.6622H144.839C145.031 56.6622 145.215 56.7386 145.351 56.8745C145.487 57.0105 145.564 57.1949 145.564 57.3872C145.564 57.5795 145.487 57.764 145.351 57.8999C145.215 58.0359 145.031 58.1123 144.839 58.1123Z"
              fill="#222433"/>
        <path d="M144.839 46.6948H139.814C139.621 46.6948 139.437 46.6184 139.301 46.4825C139.165 46.3465 139.089 46.1621 139.089 45.9698C139.089 45.7775 139.165 45.593 139.301 45.4571C139.437 45.3211 139.621 45.2447 139.814 45.2447H144.839C145.031 45.2447 145.215 45.3211 145.351 45.4571C145.487 45.593 145.564 45.7775 145.564 45.9698C145.564 46.1621 145.487 46.3465 145.351 46.4825C145.215 46.6184 145.031 46.6948 144.839 46.6948Z"
              fill="#222433"/>
        <path d="M144.839 35.2774H139.814C139.621 35.2774 139.437 35.201 139.301 35.065C139.165 34.929 139.089 34.7446 139.089 34.5523C139.089 34.36 139.165 34.1756 139.301 34.0396C139.437 33.9036 139.621 33.8272 139.814 33.8272H144.839C145.031 33.8272 145.215 33.9036 145.351 34.0396C145.487 34.1756 145.564 34.36 145.564 34.5523C145.564 34.7446 145.487 34.929 145.351 35.065C145.215 35.201 145.031 35.2774 144.839 35.2774Z"
              fill="#222433"/>
        <path d="M144.839 23.8599H139.814C139.621 23.8599 139.437 23.7835 139.301 23.6475C139.165 23.5115 139.089 23.3271 139.089 23.1348C139.089 22.9425 139.165 22.7581 139.301 22.6221C139.437 22.4861 139.621 22.4097 139.814 22.4097H144.839C145.031 22.4097 145.215 22.4861 145.351 22.6221C145.487 22.7581 145.564 22.9425 145.564 23.1348C145.564 23.3271 145.487 23.5115 145.351 23.6475C145.215 23.7835 145.031 23.8599 144.839 23.8599Z"
              fill="#222433"/>
        <path d="M165.764 55.4251C167.393 55.1257 168.471 53.5619 168.172 51.9323C167.873 50.3028 166.309 49.2245 164.679 49.5239C163.05 49.8234 161.971 51.3871 162.271 53.0167C162.57 54.6463 164.134 55.7246 165.764 55.4251Z"
              fill="#222222"/>
        <path d="M200.389 21.4434C202.019 21.1439 203.097 19.5802 202.798 17.9506C202.498 16.321 200.935 15.2427 199.305 15.5422C197.676 15.8416 196.597 17.4054 196.897 19.0349C197.196 20.6645 198.76 21.7428 200.389 21.4434Z"
              fill="#222222"/>
        <path d="M134.138 83.0917H133.318C132.678 83.0929 132.051 82.9034 131.519 82.5472C130.986 82.1911 130.572 81.6845 130.328 81.0919L129.277 78.5542C129.143 78.2271 128.914 77.9474 128.62 77.7508C128.326 77.5542 127.98 77.4495 127.627 77.4501H126.725C126.533 77.4501 126.348 77.3738 126.212 77.2378C126.076 77.1018 126 76.9174 126 76.7251C126 76.5328 126.076 76.3484 126.212 76.2124C126.348 76.0764 126.533 76 126.725 76H127.627C128.267 75.9988 128.894 76.1883 129.426 76.5444C129.959 76.9005 130.373 77.407 130.617 77.9995L131.668 80.5373C131.802 80.8644 132.031 81.1441 132.325 81.3408C132.619 81.5375 132.965 81.6422 133.318 81.6415H134.138C134.33 81.6415 134.514 81.7179 134.65 81.8539C134.786 81.9899 134.863 82.1743 134.863 82.3666C134.863 82.5589 134.786 82.7433 134.65 82.8793C134.514 83.0153 134.33 83.0917 134.138 83.0917Z"
              fill="#222433"/>
        <path d="M127.627 83.0917H126.725C126.533 83.0917 126.348 83.0153 126.212 82.8793C126.076 82.7433 126 82.5589 126 82.3666C126 82.1743 126.076 81.9899 126.212 81.8539C126.348 81.7179 126.533 81.6416 126.725 81.6416H127.627C127.98 81.6422 128.326 81.5375 128.62 81.3409C128.914 81.1444 129.142 80.8648 129.277 80.5378L130.328 78C130.572 77.4076 130.986 76.9012 131.519 76.5452C132.051 76.1891 132.678 75.9997 133.318 76.001H134.138C134.33 76.001 134.514 76.0774 134.65 76.2134C134.786 76.3493 134.863 76.5338 134.863 76.7261C134.863 76.9184 134.786 77.1028 134.65 77.2388C134.514 77.3747 134.33 77.4511 134.138 77.4511H133.318C132.965 77.4504 132.619 77.555 132.325 77.7515C132.031 77.9481 131.803 78.2277 131.668 78.5547L130.617 81.0924C130.373 81.6848 129.959 82.1913 129.426 82.5473C128.894 82.9034 128.267 83.0929 127.627 83.0917Z"
              fill="#222433"/>
        <path d="M74.9888 146.542H19.1475C18.2449 146.542 17.3794 146.183 16.7412 145.545C16.103 144.907 15.7445 144.041 15.7445 143.139V142.172H76.6673L74.9888 146.542Z"
              fill="#222433"/>
        <path d="M20.7388 172.973C20.6343 172.973 20.5311 172.951 20.4362 172.907C20.3412 172.864 20.2568 172.801 20.1886 172.721C20.1205 172.642 20.0702 172.549 20.0413 172.449C20.0123 172.349 20.0054 172.243 20.0209 172.14L23.8904 146.436C23.9203 146.247 24.0237 146.078 24.1781 145.965C24.3325 145.852 24.5253 145.804 24.7145 145.833C24.9037 145.861 25.074 145.963 25.1882 146.117C25.3025 146.27 25.3514 146.463 25.3244 146.652L21.4549 172.357C21.4289 172.528 21.3424 172.685 21.211 172.798C21.0796 172.911 20.9121 172.973 20.7388 172.973Z"
              fill="#222433"/>
        <path d="M156.95 227.689C156.928 227.689 156.906 227.689 156.884 227.686C156.692 227.669 156.515 227.576 156.392 227.428C156.269 227.281 156.21 227.09 156.227 226.898C156.827 220.341 153.419 215.407 146.874 213.36C139.734 211.131 135.382 206.743 134.62 201.004C134.608 200.91 134.614 200.814 134.639 200.722C134.663 200.63 134.706 200.544 134.763 200.468C134.821 200.392 134.894 200.329 134.976 200.281C135.058 200.234 135.149 200.203 135.244 200.19C135.338 200.178 135.434 200.184 135.526 200.208C135.618 200.233 135.704 200.275 135.78 200.333C135.856 200.391 135.919 200.463 135.967 200.546C136.014 200.628 136.045 200.719 136.058 200.814C136.741 205.962 140.735 209.925 147.306 211.976C154.454 214.211 158.328 219.839 157.671 227.03C157.654 227.21 157.571 227.377 157.438 227.499C157.305 227.621 157.131 227.689 156.95 227.689Z"
              fill="#222433"/>
        <path d="M114.165 101.372H157.512C160.502 101.764 163.385 102.741 165.997 104.247C168.609 105.753 170.899 107.759 172.736 110.15C174.573 112.542 175.921 115.271 176.703 118.183C177.485 121.095 177.686 124.133 177.294 127.123C176.053 133.502 170.282 143.562 170.282 143.562L152.312 181.13L148.805 188.461L141.842 203.018L106.348 191.504L114.165 101.372Z"
              fill="#F9A825"/>
        <path d="M156.093 115.034C155.972 115.034 155.852 115.017 155.736 114.982C155.533 114.923 155.348 114.814 155.199 114.665C155.05 114.515 154.94 114.33 154.881 114.128L153.568 109.783C153.49 109.525 153.35 109.29 153.159 109.1C152.968 108.909 152.733 108.769 152.475 108.692L148.135 107.374C147.874 107.296 147.646 107.136 147.484 106.918C147.322 106.699 147.234 106.434 147.235 106.162C147.236 105.89 147.324 105.626 147.488 105.408C147.651 105.191 147.88 105.032 148.141 104.955L152.473 103.642C152.732 103.564 152.967 103.423 153.158 103.232C153.349 103.041 153.49 102.806 153.568 102.547L154.015 101.077C154.061 100.928 154.153 100.798 154.278 100.706C154.402 100.613 154.554 100.563 154.709 100.563H156.766C156.79 100.563 156.814 100.564 156.838 100.567C157.086 100.591 157.333 100.621 157.592 100.653C157.731 100.671 157.862 100.728 157.97 100.818C158.077 100.908 158.156 101.027 158.197 101.161L158.617 102.546C158.695 102.804 158.836 103.04 159.027 103.231C159.218 103.422 159.454 103.563 159.712 103.641L164.063 104.955C164.321 105.035 164.548 105.195 164.709 105.413C164.869 105.63 164.956 105.893 164.956 106.164C164.956 106.434 164.869 106.698 164.709 106.915C164.548 107.133 164.321 107.293 164.063 107.372H164.06L159.709 108.69C159.451 108.767 159.216 108.907 159.025 109.098C158.834 109.288 158.693 109.523 158.615 109.781L157.3 114.132C157.222 114.392 157.063 114.62 156.845 114.782C156.628 114.945 156.363 115.032 156.092 115.033L156.093 115.034ZM155.912 113.716V113.719V113.716ZM156.27 113.711V113.714V113.711ZM149.146 106.165L152.895 107.303C153.382 107.449 153.825 107.714 154.185 108.074C154.544 108.433 154.809 108.876 154.956 109.363L156.092 113.12L157.228 109.363C157.375 108.876 157.64 108.433 158 108.073C158.36 107.713 158.804 107.449 159.291 107.303L163.049 106.165L159.293 105.029C158.806 104.882 158.363 104.616 158.003 104.257C157.643 103.897 157.378 103.454 157.23 102.967L156.948 102.035C156.875 102.027 156.803 102.019 156.73 102.011H155.247L154.957 102.967C154.81 103.453 154.545 103.896 154.185 104.256C153.825 104.615 153.382 104.88 152.896 105.027L149.146 106.165ZM148.558 106.343H148.556H148.558ZM148.55 105.984H148.553H148.55Z"
              fill="#222433"/>
        <path d="M304.499 102.013H98.9229C98.7306 102.013 98.5462 101.936 98.4102 101.801C98.2742 101.665 98.1978 101.48 98.1978 101.288C98.1978 101.096 98.2742 100.911 98.4102 100.775C98.5462 100.639 98.7306 100.563 98.9229 100.563H304.499C304.691 100.563 304.876 100.639 305.012 100.775C305.148 100.911 305.224 101.096 305.224 101.288C305.224 101.48 305.148 101.665 305.012 101.801C304.876 101.936 304.691 102.013 304.499 102.013Z"
              fill="#222433"/>
        <path d="M71.9614 92.2607C71.7722 92.2607 71.5904 92.1868 71.4549 92.0547C71.3194 91.9225 71.241 91.7427 71.2363 91.5535L70.9584 80.3777C70.956 80.2825 70.9724 80.1878 71.0067 80.0989C71.0409 80.01 71.0924 79.9287 71.158 79.8597C71.2237 79.7907 71.3023 79.7354 71.3893 79.6967C71.4764 79.6581 71.5702 79.637 71.6654 79.6347C71.7607 79.6323 71.8554 79.6487 71.9443 79.683C72.0332 79.7172 72.1144 79.7686 72.1834 79.8343C72.2524 79.8999 72.3078 79.9785 72.3464 80.0656C72.3851 80.1527 72.4062 80.2465 72.4085 80.3417L72.6865 91.5175C72.6913 91.7097 72.6195 91.896 72.487 92.0353C72.3545 92.1746 72.172 92.2556 71.9798 92.2604L71.9614 92.2607Z"
              fill="#222433"/>
        <path d="M43.745 70.8397C39.8562 70.845 36.1034 69.4089 33.2115 66.8089C30.3197 64.2089 28.494 60.6294 28.0871 56.7619C28.0766 56.6672 28.0849 56.5713 28.1115 56.4797C28.1382 56.3882 28.1826 56.3028 28.2423 56.2284C28.3019 56.154 28.3757 56.0922 28.4593 56.0463C28.5429 56.0005 28.6348 55.9717 28.7296 55.9614C28.8243 55.9511 28.9202 55.9596 29.0117 55.9864C29.1032 56.0133 29.1885 56.0579 29.2628 56.1177C29.337 56.1775 29.3987 56.2514 29.4444 56.3351C29.49 56.4189 29.5187 56.5108 29.5288 56.6056C29.9371 60.3352 31.7919 63.7559 34.6948 66.133C37.5977 68.51 41.317 69.6537 45.0539 69.3184C48.7908 68.9832 52.2472 67.1957 54.6806 64.3399C57.114 61.4841 58.3303 57.7879 58.0683 54.0451C58.0615 53.9501 58.0736 53.8548 58.1037 53.7644C58.1339 53.6741 58.1815 53.5906 58.2439 53.5187C58.3063 53.4468 58.3822 53.3878 58.4674 53.3453C58.5526 53.3027 58.6453 53.2773 58.7403 53.2706C58.8353 53.2639 58.9306 53.2759 59.021 53.3061C59.1113 53.3362 59.1948 53.3838 59.2667 53.4462C59.3386 53.5086 59.3976 53.5846 59.4401 53.6698C59.4827 53.7549 59.5081 53.8476 59.5148 53.9426C59.8058 58.116 58.4296 62.2344 55.6881 65.3944C52.9465 68.5543 49.0635 70.4979 44.8908 70.7986C44.5068 70.8264 44.1227 70.8397 43.745 70.8397Z"
              fill="#222433"/>
        <path d="M43.9522 66.3829C41.4886 66.3894 39.1103 65.4812 37.2781 63.8343C35.446 62.1873 34.2903 59.919 34.0351 57.4686L31.8498 37.1149C31.8381 37.0195 31.8455 36.9227 31.8715 36.8302C31.8976 36.7377 31.9418 36.6513 32.0016 36.576C32.0613 36.5007 32.1355 36.4381 32.2196 36.3917C32.3038 36.3453 32.3964 36.3161 32.492 36.3059C32.5876 36.2956 32.6842 36.3044 32.7763 36.3319C32.8685 36.3593 32.9542 36.4048 33.0286 36.4656C33.103 36.5265 33.1646 36.6015 33.2097 36.6864C33.2548 36.7713 33.2826 36.8643 33.2914 36.96L35.4768 57.312C35.7244 59.5464 36.8417 61.5934 38.5871 63.0103C40.3324 64.4271 42.5654 65.0998 44.8029 64.8828C47.0405 64.6659 49.1026 63.5767 50.5432 61.8509C51.9838 60.1251 52.6871 57.9016 52.5008 55.6613L51.9565 49.1883C51.9434 49.0331 51.9806 48.8777 52.0627 48.7453C52.1448 48.6129 52.2674 48.5104 52.4123 48.4531C54.6113 47.5855 56.5537 46.1732 58.0569 44.3488C59.5602 42.5244 60.575 40.3477 61.0061 38.0234C61.4371 35.6991 61.2702 33.3033 60.521 31.0612C59.7719 28.8191 58.4651 26.8042 56.7233 25.2059C56.6243 25.1149 56.5526 24.9983 56.516 24.8689C56.4795 24.7396 56.4796 24.6026 56.5164 24.4733C57.0963 22.4411 57.2075 20.3037 56.8416 18.2223C56.4756 16.1409 55.6422 14.1696 54.4039 12.457C53.1657 10.7444 51.555 9.33513 49.6931 8.3353C47.8312 7.33546 45.7667 6.77116 43.6551 6.6849C43.4628 6.6773 43.2814 6.59363 43.1508 6.45228C43.0202 6.31093 42.9511 6.12349 42.9587 5.93119C42.9663 5.73889 43.05 5.55748 43.1913 5.42688C43.3327 5.29627 43.5201 5.22716 43.7124 5.23476C46.0062 5.32774 48.2503 5.93188 50.2807 7.00303C52.3112 8.07419 54.0768 9.58532 55.4485 11.4261C56.8203 13.2668 57.7636 15.3907 58.2096 17.6427C58.6556 19.8946 58.5929 22.2177 58.0263 24.4424C59.8375 26.2034 61.1875 28.383 61.9573 30.7891C62.7271 33.1951 62.893 35.7536 62.4404 38.2389C61.9878 40.7242 60.9306 43.06 59.3621 45.0402C57.7935 47.0204 55.7617 48.5842 53.446 49.5936L53.9461 55.5392C54.1631 58.1814 53.3244 60.8019 51.6138 62.8272C49.9031 64.8525 47.4597 66.1175 44.8184 66.3454C44.5276 66.3708 44.2383 66.3829 43.9522 66.3829Z"
              fill="#222433"/>
        <path d="M47.2982 50.8818C45.5127 50.8818 43.7407 50.5726 42.0607 49.968C41.8798 49.9029 41.7321 49.7685 41.6502 49.5945C41.5683 49.4205 41.5589 49.2211 41.624 49.0401C41.6891 48.8592 41.8235 48.7115 41.9975 48.6296C42.1715 48.5477 42.3709 48.5383 42.5518 48.6034C45.7485 49.7541 49.2544 49.7043 52.4172 48.4632C52.506 48.4274 52.601 48.4096 52.6968 48.4108C52.7925 48.4119 52.8871 48.432 52.9751 48.4699C53.063 48.5078 53.1426 48.5627 53.2092 48.6316C53.2758 48.7004 53.3281 48.7817 53.3631 48.8709C53.398 48.96 53.415 49.0552 53.413 49.151C53.411 49.2467 53.3901 49.3411 53.3514 49.4287C53.3127 49.5163 53.257 49.5954 53.1876 49.6613C53.1182 49.7273 53.0364 49.7789 52.9469 49.8131C51.1474 50.5193 49.2313 50.8818 47.2982 50.8818Z"
              fill="#222433"/>
        <path d="M56.1213 1.41658C55.2212 1.41623 54.3352 1.63929 53.5426 2.06576C52.7499 2.49223 52.0756 3.10876 51.5799 3.86007C51.1206 3.00567 50.4414 2.28948 49.6126 1.78555C48.7837 1.28162 47.8353 1.00825 46.8654 0.993715C45.8955 0.979176 44.9393 1.22399 44.0957 1.70285C43.2521 2.18171 42.5517 2.87722 42.067 3.71747C41.5475 2.99958 40.8325 2.44613 40.0074 2.12301C39.1822 1.79988 38.2816 1.7207 37.4127 1.89488C36.5438 2.06906 35.7433 2.48928 35.1064 3.10549C34.4696 3.7217 34.0232 4.50795 33.8205 5.37063C33.0921 5.0052 32.2745 4.85532 31.4638 4.93861C30.6531 5.0219 29.883 5.33489 29.2441 5.8408C28.6052 6.3467 28.124 7.0245 27.857 7.7945C27.5901 8.5645 27.5485 9.3947 27.7372 10.1875C27.0319 10.4198 26.399 10.8311 25.9003 11.3813C25.4017 11.9315 25.0544 12.6017 24.8924 13.3264C24.7304 14.0511 24.7593 14.8054 24.9762 15.5155C25.1932 16.2257 25.5907 16.8673 26.13 17.3778C25.5537 17.6374 25.0418 18.0209 24.6308 18.501C24.2197 18.9811 23.9196 19.5459 23.7519 20.1552C23.5841 20.7646 23.5529 21.4034 23.6603 22.0262C23.7677 22.649 24.0112 23.2405 24.3734 23.7584C26.7497 21.6966 29.5878 20.958 31.8677 21.4525C34.1357 21.9445 37.5189 23.757 38.3252 28.4716H39.0019L37.8674 18.5476C37.7635 17.7625 37.9742 16.9682 38.4537 16.3379C38.9332 15.7076 39.6425 15.2926 40.4269 15.1833L55.6921 13.0612C59.8975 11.9108 61.5893 9.87815 61.5893 6.87153C61.5906 6.15644 61.451 5.44811 61.1785 4.78697C60.906 4.12583 60.506 3.52484 60.0013 3.0183C59.4965 2.51176 58.8969 2.1096 58.2368 1.83477C57.5766 1.55995 56.8688 1.41785 56.1537 1.41658H56.1213Z"
              fill="#222222"/>
        <path d="M50.1484 29.6266C50.0531 29.6291 49.9584 29.6128 49.8695 29.5786C49.7806 29.5444 49.6992 29.4931 49.6302 29.4275C49.5611 29.3619 49.5056 29.2834 49.4669 29.1963C49.4282 29.1093 49.407 29.0155 49.4046 28.9203C49.4021 28.8251 49.4184 28.7303 49.4526 28.6414C49.4868 28.5525 49.5381 28.4712 49.6037 28.4021C49.6693 28.333 49.7478 28.2776 49.8349 28.2389C49.9219 28.2001 50.0157 28.179 50.1109 28.1765L53.3469 28.0054L51.6925 22.4864C51.6373 22.3022 51.6576 22.1036 51.7488 21.9343C51.8401 21.765 51.9948 21.6389 52.1791 21.5837C52.3633 21.5285 52.5619 21.5487 52.7312 21.64C52.9005 21.7312 53.0266 21.886 53.0818 22.0702L55.0008 28.4726C55.0323 28.5777 55.0395 28.6887 55.0219 28.7971C55.0043 28.9054 54.9623 29.0084 54.8991 29.0982C54.8358 29.1879 54.7531 29.2622 54.657 29.3153C54.5609 29.3684 54.454 29.399 54.3444 29.4048L50.1873 29.6247C50.1745 29.6264 50.1614 29.6266 50.1484 29.6266Z"
              fill="#222433"/>
        <path d="M45.847 26.2116C46.7013 26.2116 47.3938 25.519 47.3938 24.6647C47.3938 23.8105 46.7013 23.1179 45.847 23.1179C44.9927 23.1179 44.3002 23.8105 44.3002 24.6647C44.3002 25.519 44.9927 26.2116 45.847 26.2116Z"
              fill="#222433"/>
        <path d="M55.8554 24.9693C56.7097 24.9693 57.4022 24.2768 57.4022 23.4225C57.4022 22.5682 56.7097 21.8757 55.8554 21.8757C55.0011 21.8757 54.3086 22.5682 54.3086 23.4225C54.3086 24.2768 55.0011 24.9693 55.8554 24.9693Z"
              fill="#222433"/>
        <path d="M30.2962 38.094C30.1816 38.094 30.0668 38.0917 29.9518 38.0872C28.799 38.0475 27.6654 37.7805 26.616 37.3017C25.5667 36.8228 24.6222 36.1414 23.8369 35.2966C23.0515 34.4518 22.4406 33.4603 22.0394 32.3789C21.6382 31.2975 21.4544 30.1475 21.4987 28.9948C21.543 27.8422 21.8144 26.7097 22.2974 25.6623C22.7804 24.6148 23.4655 23.673 24.3134 22.891C25.1613 22.109 26.1552 21.5021 27.2382 21.1051C28.3212 20.7081 29.472 20.5289 30.6244 20.5777C32.7246 20.6666 34.7236 21.5042 36.26 22.9389C37.7963 24.3737 38.7685 26.3108 39.0006 28.4C39.0107 28.4947 39.0019 28.5905 38.9749 28.6818C38.9479 28.7731 38.9032 28.8582 38.8434 28.9323C38.7835 29.0063 38.7096 29.0678 38.626 29.1133C38.5423 29.1588 38.4505 29.1874 38.3558 29.1974C38.2611 29.2074 38.1654 29.1987 38.0741 29.1717C37.9827 29.1447 37.8976 29.1 37.8236 29.0401C37.7496 28.9802 37.688 28.9063 37.6425 28.8227C37.5971 28.739 37.5685 28.6472 37.5585 28.5525C37.3614 26.7158 36.4763 25.0218 35.0813 23.8109C33.6862 22.6 31.8845 21.9621 30.0383 22.0253C28.1921 22.0886 26.4382 22.8483 25.1293 24.1518C23.8203 25.4553 23.0533 27.206 22.9824 29.0519C22.9302 30.4031 23.2539 31.7423 23.9173 32.9206C24.5807 34.099 25.5579 35.0702 26.7403 35.7264C27.9227 36.3826 29.2638 36.698 30.6147 36.6376C31.9656 36.5772 33.2733 36.1433 34.3923 35.3842C34.4711 35.3293 34.5599 35.2907 34.6537 35.2704C34.7475 35.2502 34.8444 35.2488 34.9388 35.2663C35.0331 35.2838 35.1231 35.3198 35.2034 35.3723C35.2837 35.4248 35.3528 35.4928 35.4067 35.5722C35.4606 35.6516 35.4981 35.7409 35.5172 35.8349C35.5363 35.929 35.5366 36.0259 35.5179 36.12C35.4993 36.2142 35.4622 36.3037 35.4087 36.3833C35.3552 36.463 35.2864 36.5313 35.2063 36.5842C33.759 37.5704 32.0476 38.0967 30.2962 38.094Z"
              fill="#222433"/>
        <path d="M29.3183 31.9447C29.1544 31.945 28.9952 31.8897 28.8667 31.7879C28.7382 31.686 28.6481 31.5437 28.6109 31.384C28.5737 31.2243 28.5918 31.0568 28.6621 30.9087C28.7324 30.7606 28.8509 30.6407 28.9981 30.5686L32.1884 29.0014L26.7745 27.5324C26.5889 27.4821 26.4309 27.36 26.3353 27.1931C26.2397 27.0263 26.2143 26.8283 26.2647 26.6427C26.3151 26.4571 26.4371 26.2991 26.604 26.2035C26.7708 26.1078 26.9689 26.0824 27.1545 26.1328L34.4221 28.1052C34.5642 28.1439 34.6912 28.2249 34.7862 28.3375C34.8811 28.4501 34.9395 28.5889 34.9536 28.7356C34.9677 28.8822 34.9368 29.0296 34.8651 29.1582C34.7933 29.2869 34.684 29.3906 34.5519 29.4556L29.6383 31.8701C29.5388 31.9192 29.4293 31.9448 29.3183 31.9447Z"
              fill="#222433"/>
        <path d="M52.9356 37.8932C51.8452 37.9134 50.7792 37.5692 49.9064 36.9153C49.0336 36.2614 48.4039 35.335 48.117 34.2828C48.0884 34.1909 48.0784 34.0943 48.0875 33.9986C48.0967 33.9029 48.1248 33.8099 48.1702 33.7251C48.2156 33.6403 48.2774 33.5654 48.3521 33.5048C48.4267 33.4441 48.5127 33.3989 48.605 33.3718C48.6972 33.3447 48.794 33.3362 48.8896 33.3468C48.9852 33.3575 49.0777 33.387 49.1617 33.4338C49.2458 33.4805 49.3197 33.5435 49.3792 33.6191C49.4387 33.6947 49.4825 33.7814 49.5081 33.8741C49.7396 34.707 50.2696 35.4255 50.997 35.8925C51.7245 36.3595 52.5984 36.5423 53.452 36.406C54.7052 36.2257 56.1686 35.2979 56.1686 33.2757C56.1686 33.0834 56.245 32.8989 56.381 32.763C56.517 32.627 56.7014 32.5506 56.8937 32.5506C57.086 32.5506 57.2704 32.627 57.4064 32.763C57.5424 32.8989 57.6188 33.0834 57.6188 33.2757C57.6188 36.036 55.6299 37.5579 53.6587 37.8414C53.4192 37.8758 53.1775 37.8931 52.9356 37.8932Z"
              fill="#222433"/>
        <path d="M122.59 172.403C122.32 172.403 122.057 172.316 121.84 172.156C121.622 171.996 121.462 171.77 121.382 171.513L120.066 167.158C119.987 166.9 119.846 166.665 119.655 166.475C119.464 166.284 119.229 166.144 118.971 166.066C118.879 166.039 118.793 165.994 118.718 165.934C118.643 165.874 118.581 165.799 118.535 165.715C118.489 165.631 118.461 165.538 118.451 165.442C118.441 165.347 118.45 165.25 118.478 165.159C118.506 165.067 118.552 164.981 118.613 164.907C118.674 164.833 118.75 164.772 118.835 164.727C118.92 164.683 119.013 164.655 119.108 164.647C119.204 164.638 119.3 164.649 119.392 164.678C119.878 164.825 120.321 165.09 120.681 165.449C121.04 165.808 121.306 166.25 121.453 166.736L122.589 170.495L123.725 166.738C123.873 166.252 124.138 165.809 124.498 165.45C124.858 165.09 125.301 164.825 125.787 164.678L129.535 163.542L125.787 162.404C125.302 162.259 124.861 161.996 124.502 161.64C124.142 161.284 123.876 160.845 123.727 160.362L122.558 156.494C122.529 156.403 122.519 156.307 122.528 156.211C122.536 156.116 122.564 156.023 122.609 155.938C122.654 155.853 122.715 155.778 122.789 155.717C122.863 155.656 122.948 155.611 123.04 155.583C123.132 155.555 123.228 155.546 123.324 155.556C123.419 155.566 123.511 155.594 123.596 155.64C123.68 155.686 123.754 155.748 123.814 155.822C123.875 155.897 123.919 155.983 123.946 156.075L125.113 159.937C125.193 160.193 125.334 160.425 125.525 160.613C125.715 160.801 125.949 160.94 126.206 161.016L130.547 162.334C130.805 162.413 131.032 162.573 131.193 162.79C131.354 163.007 131.442 163.27 131.442 163.541C131.442 163.811 131.356 164.075 131.196 164.293C131.035 164.51 130.809 164.671 130.551 164.751L126.208 166.067C125.949 166.145 125.714 166.286 125.523 166.477C125.332 166.667 125.191 166.902 125.113 167.161L123.799 171.509C123.719 171.768 123.559 171.994 123.342 172.155C123.124 172.316 122.861 172.403 122.59 172.403V172.403Z"
              fill="#222433"/>
        <path d="M78.0464 162.985C77.9714 162.834 77.8666 162.699 77.7383 162.59C77.6099 162.48 77.4607 162.397 77.2996 162.347L72.9589 161.027C72.701 160.95 72.4664 160.81 72.2761 160.62C72.0858 160.43 71.9458 160.195 71.8688 159.937L70.6652 155.964L69.7516 157.953L70.4791 160.355C70.6258 160.842 70.8905 161.285 71.2498 161.645C71.6091 162.005 72.0517 162.27 72.5383 162.417L76.2676 163.548L72.5407 164.677C72.0536 164.824 71.6104 165.089 71.2507 165.449C70.891 165.808 70.6259 166.251 70.4791 166.739L69.3407 170.496L68.2048 166.735C68.0808 166.326 67.873 165.947 67.5947 165.623C67.3163 165.298 66.9734 165.035 66.5879 164.85L66.409 165.242L65.9837 166.17C66.1821 166.269 66.3583 166.408 66.5016 166.577C66.6449 166.747 66.7524 166.944 66.8175 167.156L68.1347 171.511C68.1954 171.708 68.303 171.886 68.4483 172.031C68.5936 172.177 68.7722 172.284 68.9685 172.345C69.089 172.383 69.2145 172.403 69.3407 172.403C69.6115 172.402 69.8748 172.315 70.0926 172.154C70.3104 171.993 70.4712 171.767 70.5516 171.509L71.8688 167.158C71.9453 166.9 72.085 166.665 72.2753 166.474C72.4657 166.283 72.7006 166.143 72.9589 166.066L77.2972 164.751L77.3189 164.744C77.5035 164.681 77.6711 164.577 77.809 164.439C77.9468 164.301 78.0512 164.133 78.1141 163.949C78.1667 163.792 78.1878 163.626 78.1762 163.46C78.1646 163.295 78.1205 163.133 78.0464 162.985Z"
              fill="#222433"/>
        <path d="M100.856 152.021C100.585 152.021 100.322 151.933 100.104 151.772C99.8864 151.61 99.7265 151.383 99.6477 151.124L98.3308 146.774C98.2529 146.516 98.1125 146.281 97.922 146.09C97.7314 145.9 97.4968 145.759 97.2388 145.682L92.8884 144.364C92.6277 144.286 92.3992 144.126 92.2369 143.908C92.0746 143.69 91.9873 143.425 91.9879 143.153C91.9885 142.881 92.0771 142.616 92.2404 142.398C92.4036 142.181 92.6329 142.022 92.894 141.945L97.2391 140.632C97.4969 140.554 97.7315 140.413 97.9219 140.222C98.1124 140.032 98.2529 139.797 98.331 139.539L99.648 135.189C99.7265 134.93 99.8862 134.703 100.104 134.541C100.321 134.38 100.585 134.293 100.855 134.293C101.126 134.293 101.39 134.38 101.607 134.541C101.825 134.703 101.984 134.93 102.063 135.189L103.38 139.539C103.458 139.797 103.599 140.032 103.79 140.222C103.98 140.413 104.215 140.553 104.473 140.631L108.823 141.946C109.084 142.024 109.313 142.184 109.475 142.402C109.637 142.621 109.724 142.886 109.724 143.158C109.723 143.43 109.635 143.694 109.472 143.912C109.308 144.13 109.079 144.289 108.818 144.365L104.473 145.681C104.215 145.759 103.981 145.899 103.79 146.09C103.6 146.28 103.459 146.515 103.381 146.773L102.064 151.123C101.985 151.382 101.826 151.609 101.609 151.77C101.392 151.932 101.129 152.019 100.858 152.02L100.856 152.021ZM93.8999 143.156L97.6579 144.294C98.1445 144.441 98.5873 144.705 98.9467 145.065C99.306 145.424 99.5709 145.867 99.7176 146.354L100.854 150.108L101.989 146.353C102.136 145.867 102.401 145.424 102.76 145.065C103.12 144.705 103.563 144.441 104.049 144.294L107.807 143.156L104.049 142.02C103.563 141.873 103.121 141.608 102.761 141.249C102.402 140.89 102.137 140.447 101.99 139.961L100.854 136.206L99.7178 139.96C99.5707 140.447 99.3058 140.889 98.9466 141.248C98.5874 141.607 98.1451 141.872 97.6589 142.02L93.8999 143.156ZM108.404 143.336H108.407H108.404ZM93.3097 143.334H93.3072H93.3097ZM108.402 142.977H108.399H108.402ZM93.3019 142.975H93.3048H93.3019Z"
              fill="#222433"/>
        <path d="M105.586 188.68C105.315 188.68 105.051 188.593 104.834 188.431C104.616 188.27 104.456 188.042 104.378 187.783L103.06 183.433C102.983 183.175 102.842 182.94 102.652 182.75C102.461 182.559 102.226 182.419 101.968 182.341L97.618 181.024C97.3574 180.946 97.1289 180.786 96.9666 180.567C96.8043 180.349 96.717 180.084 96.7177 179.812C96.7183 179.54 96.8069 179.275 96.9702 179.058C97.1335 178.84 97.3628 178.681 97.6238 178.604L101.969 177.291C102.227 177.213 102.461 177.072 102.652 176.882C102.842 176.691 102.983 176.456 103.061 176.199L104.378 171.848C104.456 171.589 104.616 171.362 104.833 171.2C105.051 171.039 105.314 170.952 105.585 170.952C105.856 170.952 106.12 171.039 106.337 171.2C106.555 171.362 106.714 171.589 106.793 171.848L108.11 176.199C108.188 176.456 108.329 176.691 108.52 176.882C108.71 177.072 108.945 177.213 109.203 177.291L112.597 178.316C112.688 178.344 112.773 178.389 112.847 178.45C112.92 178.51 112.981 178.584 113.026 178.668C113.071 178.752 113.099 178.844 113.109 178.939C113.118 179.034 113.109 179.129 113.081 179.22C113.054 179.312 113.009 179.396 112.948 179.47C112.888 179.544 112.814 179.605 112.73 179.65C112.646 179.695 112.554 179.723 112.459 179.732C112.364 179.742 112.269 179.732 112.177 179.705L108.782 178.679C108.296 178.531 107.853 178.266 107.494 177.907C107.135 177.548 106.87 177.106 106.722 176.619L105.585 172.864L104.449 176.62C104.302 177.106 104.037 177.548 103.677 177.907C103.318 178.267 102.876 178.532 102.39 178.679L98.6307 179.815L102.389 180.953C102.876 181.1 103.318 181.365 103.678 181.724C104.037 182.083 104.302 182.526 104.449 183.013L105.585 186.767L106.721 183.013C106.867 182.526 107.132 182.083 107.492 181.724C107.851 181.365 108.294 181.1 108.78 180.953L111.277 180.197C111.461 180.141 111.659 180.161 111.829 180.252C111.999 180.342 112.125 180.497 112.181 180.681C112.237 180.865 112.217 181.064 112.126 181.233C112.035 181.403 111.881 181.529 111.697 181.585L109.201 182.341C108.943 182.419 108.708 182.559 108.517 182.75C108.327 182.94 108.186 183.175 108.109 183.433L106.791 187.783C106.713 188.042 106.553 188.269 106.336 188.431C106.119 188.592 105.856 188.679 105.585 188.68H105.586ZM98.0395 179.994H98.0371H98.0395ZM98.0318 179.635H98.0347H98.0318Z"
              fill="#222433"/>
        <path d="M129.414 138.746C129.141 138.746 128.876 138.657 128.658 138.494C128.44 138.331 128.281 138.101 128.203 137.84L126.89 133.508C126.812 133.249 126.671 133.014 126.48 132.823C126.289 132.632 126.054 132.491 125.795 132.413L121.445 131.098C121.184 131.02 120.956 130.86 120.793 130.642C120.631 130.424 120.544 130.159 120.544 129.887C120.545 129.615 120.634 129.35 120.797 129.132C120.96 128.915 121.189 128.756 121.45 128.679L125.795 127.366C126.054 127.287 126.289 127.146 126.48 126.955C126.671 126.764 126.811 126.529 126.889 126.271L128.204 121.92C128.283 121.662 128.442 121.435 128.66 121.274C128.877 121.112 129.14 121.025 129.411 121.025C129.681 121.024 129.945 121.11 130.162 121.271C130.38 121.431 130.541 121.657 130.621 121.915L131.937 126.271C132.016 126.529 132.157 126.764 132.348 126.955C132.539 127.146 132.774 127.287 133.032 127.365L136.229 128.334C136.403 128.387 136.551 128.503 136.644 128.66C136.736 128.817 136.766 129.002 136.728 129.18C136.642 129.58 136.543 129.984 136.433 130.382C136.422 130.423 136.407 130.464 136.388 130.503L136.028 131.257C135.985 131.348 135.923 131.428 135.846 131.494C135.77 131.56 135.68 131.609 135.584 131.638L133.032 132.411C132.773 132.49 132.538 132.631 132.347 132.822C132.156 133.013 132.015 133.248 131.937 133.506L130.624 137.846C130.546 138.106 130.386 138.335 130.168 138.497C129.95 138.659 129.685 138.747 129.414 138.746ZM129.234 137.428V137.431V137.428ZM129.592 137.423V137.425V137.423ZM122.459 129.889L126.216 131.025C126.703 131.173 127.146 131.438 127.506 131.797C127.865 132.157 128.131 132.6 128.278 133.087L129.414 136.835L130.55 133.089C130.697 132.602 130.963 132.159 131.322 131.799C131.682 131.439 132.125 131.174 132.612 131.027L134.858 130.346L135.051 129.939C135.089 129.803 135.124 129.666 135.159 129.529L132.611 128.756C132.124 128.609 131.681 128.344 131.321 127.984C130.962 127.625 130.696 127.182 130.549 126.695L129.413 122.937L128.277 126.694C128.13 127.181 127.865 127.624 127.505 127.984C127.145 128.344 126.702 128.609 126.215 128.756L122.459 129.889ZM121.868 130.068H121.865H121.868ZM121.86 129.708H121.863H121.86Z"
              fill="#222433"/>
        <path d="M89.1891 109.113C89.0152 109.113 88.847 109.051 88.7153 108.937C88.5836 108.823 88.4972 108.666 88.4718 108.494C88.4464 108.322 88.4837 108.147 88.5769 108C88.6701 107.853 88.813 107.744 88.9796 107.694L90.9131 107.11C91.1713 107.032 91.4063 106.891 91.5973 106.7C91.7882 106.51 91.9292 106.275 92.0077 106.017L92.5326 104.28C92.5594 104.187 92.6041 104.102 92.6643 104.027C92.7244 103.952 92.7988 103.89 92.883 103.845C92.9673 103.799 93.0598 103.77 93.1552 103.76C93.2506 103.751 93.347 103.76 93.4387 103.788C93.5305 103.815 93.6159 103.861 93.6899 103.922C93.7639 103.983 93.8251 104.058 93.8699 104.143C93.9147 104.228 93.9423 104.32 93.951 104.416C93.9597 104.511 93.9494 104.608 93.9207 104.699L93.3952 106.438C93.2476 106.924 92.9821 107.367 92.6225 107.726C92.2628 108.085 91.82 108.351 91.3334 108.498L89.3999 109.082C89.3315 109.103 89.2605 109.113 89.1891 109.113Z"
              fill="#222433"/>
        <path d="M94.5323 118.491C94.4113 118.49 94.2909 118.473 94.1749 118.439C93.9721 118.38 93.7875 118.27 93.6381 118.121C93.4887 117.972 93.3794 117.787 93.3203 117.584L92.0072 113.252C91.94 113.031 91.8271 112.827 91.6758 112.653C91.5245 112.479 91.3382 112.339 91.1291 112.242C90.9546 112.161 90.8195 112.014 90.7534 111.833C90.6872 111.653 90.6955 111.453 90.7765 111.279C90.8574 111.104 91.0043 110.969 91.1849 110.903C91.3655 110.837 91.5649 110.845 91.7394 110.926C92.1337 111.109 92.485 111.374 92.7702 111.702C93.0555 112.03 93.2684 112.415 93.3949 112.831L94.5309 116.579L95.669 112.831C95.8153 112.344 96.0801 111.901 96.4396 111.541C96.7992 111.182 97.2422 110.917 97.7292 110.771L101.475 109.633L97.7275 108.498C97.2409 108.351 96.7983 108.086 96.4389 107.726C96.0796 107.367 95.8148 106.924 95.668 106.438L95.0582 104.424C95.0289 104.332 95.0182 104.236 95.0265 104.14C95.0349 104.044 95.0622 103.951 95.107 103.866C95.1517 103.781 95.2129 103.705 95.287 103.644C95.3612 103.583 95.4468 103.537 95.5388 103.509C95.6309 103.481 95.7275 103.472 95.8232 103.482C95.9189 103.492 96.0116 103.52 96.096 103.566C96.1805 103.612 96.2549 103.675 96.315 103.75C96.3751 103.825 96.4196 103.911 96.446 104.004L97.0558 106.018C97.1336 106.275 97.274 106.51 97.4646 106.701C97.6551 106.891 97.8898 107.032 98.1478 107.109L102.486 108.425C102.747 108.502 102.975 108.663 103.138 108.881C103.3 109.099 103.387 109.364 103.386 109.636C103.386 109.908 103.297 110.173 103.134 110.39C102.971 110.608 102.742 110.767 102.481 110.844L98.1485 112.159C97.8903 112.236 97.6554 112.376 97.4647 112.567C97.274 112.757 97.1336 112.992 97.0561 113.25L95.7393 117.59C95.6614 117.85 95.502 118.077 95.2846 118.24C95.0673 118.402 94.8035 118.49 94.5323 118.49V118.491ZM94.3508 117.172V117.175V117.172ZM94.709 117.166V117.169V117.166ZM102.069 109.813H102.072H102.069ZM102.066 109.454H102.063H102.066Z"
              fill="#222433"/>
        <path d="M63.9186 142.595C63.6477 142.595 63.384 142.507 63.1664 142.346C62.9489 142.184 62.7889 141.957 62.7102 141.698L61.3922 137.36C61.3146 137.102 61.1742 136.866 60.9835 136.675C60.7929 136.484 60.5579 136.343 60.2996 136.265L55.9617 134.95C55.701 134.873 55.4725 134.712 55.3103 134.494C55.148 134.276 55.0608 134.011 55.0614 133.739C55.0621 133.466 55.1507 133.202 55.3141 132.984C55.4774 132.767 55.7067 132.608 55.9677 132.531L60.3 131.218C60.5582 131.14 60.7929 130.999 60.9835 130.808C61.174 130.617 61.3143 130.382 61.392 130.124L62.7095 125.774C62.7879 125.514 62.9476 125.287 63.1651 125.126C63.3826 124.964 63.6462 124.877 63.9171 124.877C64.1879 124.877 64.4515 124.964 64.669 125.126C64.8865 125.287 65.0463 125.514 65.1247 125.774L66.4416 130.124C66.5198 130.382 66.6604 130.618 66.8511 130.809C67.0419 131 67.2768 131.141 67.535 131.219L71.8722 132.534C72.1328 132.612 72.3612 132.772 72.5233 132.99C72.6855 133.208 72.7728 133.473 72.7721 133.745C72.7715 134.017 72.683 134.282 72.5197 134.499C72.3565 134.717 72.1273 134.876 71.8664 134.953L67.5338 136.266C67.2758 136.344 67.0411 136.485 66.8506 136.676C66.6601 136.867 66.5196 137.102 66.4416 137.36L65.1244 141.699C65.0458 141.958 64.8863 142.184 64.6692 142.346C64.4522 142.507 64.1891 142.595 63.9186 142.595V142.595ZM56.9732 133.742L60.7194 134.878C61.2062 135.025 61.649 135.29 62.0084 135.65C62.3678 136.01 62.6325 136.453 62.7791 136.94L63.915 140.684L65.0509 136.938C65.198 136.452 65.4628 136.009 65.8218 135.65C66.1809 135.29 66.623 135.025 67.1092 134.877L70.8578 133.741L67.1116 132.605C66.6255 132.457 66.1833 132.192 65.8242 131.833C65.4652 131.473 65.2003 131.031 65.0531 130.544L63.9172 126.79L62.7812 130.544C62.6347 131.031 62.3701 131.474 62.0108 131.834C61.6516 132.194 61.2089 132.459 60.7223 132.606L56.9732 133.742ZM71.4545 133.922H71.4574H71.4545ZM56.3849 133.92H56.3822H56.3849ZM71.4516 133.563H71.449H71.4516ZM56.3762 133.561H56.3793H56.3762Z"
              fill="#222433"/>
        <path d="M65.5769 119.262C63.403 119.231 61.2953 118.509 59.5588 117.201C57.5516 115.724 54.1899 112.192 54.2281 105.129C54.2313 104.938 54.3093 104.755 54.4456 104.62C54.5818 104.485 54.7654 104.409 54.957 104.408C55.0523 104.409 55.1464 104.428 55.2342 104.465C55.322 104.502 55.4016 104.555 55.4686 104.623C55.5356 104.691 55.5886 104.771 55.6245 104.859C55.6605 104.947 55.6788 105.042 55.6782 105.137C55.6437 111.558 58.6332 114.72 60.4183 116.033C62.6573 117.681 65.3729 118.226 67.6811 117.493C71.3289 116.335 73.1348 112.611 73.7419 111.063C73.8122 110.883 73.9506 110.74 74.1269 110.663C74.3031 110.586 74.5027 110.582 74.6818 110.652C74.8608 110.722 75.0046 110.861 75.0815 111.037C75.1585 111.213 75.1622 111.413 75.092 111.592C74.409 113.332 72.3624 117.528 68.12 118.875C67.2972 119.134 66.4394 119.265 65.5769 119.262Z"
              fill="#222433"/>
        <path d="M65.1107 116.176C63.4123 116.16 61.7459 115.713 60.2677 114.876C56.4674 112.786 54.0449 108.581 54.2392 104.413C54.3231 102.64 54.7357 100.033 56.2235 97.6748C57.7829 95.2035 60.1314 93.6082 63.204 92.9331C69.3401 91.5724 71.1073 91.0907 71.1237 91.0859C77.2334 89.2333 94.1919 88.3495 98.6281 91.7459C99.6775 92.5496 99.8757 93.445 99.8571 94.0548C99.7933 96.1367 97.7822 96.63 97.1212 96.7922C95.7803 97.1209 93.8878 97.2357 91.5176 97.3507C95.5801 98.0516 97.8358 98.9722 98.8492 100.257C99.0879 100.546 99.262 100.883 99.3598 101.245C99.4576 101.607 99.4768 101.986 99.4162 102.356C98.9346 105.486 93.1458 105.558 85.2196 104.937C89.2457 107.284 92.8258 109.687 92.0698 112.063C91.9566 112.467 91.7593 112.843 91.491 113.165C91.2227 113.488 90.8893 113.751 90.5126 113.936C88.5327 114.893 85.4371 113.724 82.706 112.693C82.2514 112.521 81.8094 112.355 81.3895 112.204C76.9453 110.615 73.9435 111.858 70.8035 114.214C70.7233 114.274 70.6408 114.333 70.5567 114.392L70.52 114.418C68.9432 115.552 67.0526 116.166 65.1107 116.176ZM55.6879 104.481C55.5188 108.109 57.6401 111.776 60.9665 113.605C63.8834 115.209 67.0609 115.074 69.6842 113.233L69.7183 113.209C69.7908 113.157 69.8633 113.106 69.9339 113.054C72.9746 110.772 76.5265 108.925 81.8782 110.839C82.3058 110.991 82.7558 111.161 83.2187 111.336C85.5548 112.218 88.4633 113.316 89.8813 112.63C90.0804 112.53 90.2556 112.388 90.3949 112.214C90.5341 112.04 90.6342 111.838 90.6883 111.622C91.1988 110.018 85.893 106.985 82.7227 105.174C82.3602 104.967 82.0058 104.763 81.661 104.565C81.5177 104.483 81.407 104.354 81.3472 104.2C81.2873 104.046 81.2819 103.876 81.3317 103.718C81.3816 103.561 81.4839 103.425 81.6215 103.333C81.7591 103.242 81.9239 103.2 82.0885 103.215C85.4219 103.516 89.5707 103.89 92.7843 103.782C97.1105 103.636 97.8982 102.687 97.9833 102.135C98.0124 101.962 98.0031 101.784 97.956 101.615C97.909 101.445 97.8253 101.288 97.7109 101.155C96.1087 99.1247 88.7729 98.2979 83.3944 97.8537C83.2134 97.839 83.0445 97.7569 82.9211 97.6236C82.7978 97.4904 82.7289 97.3157 82.7281 97.1342C82.7273 96.9526 82.7947 96.7773 82.9169 96.643C83.0391 96.5087 83.2072 96.4252 83.3881 96.4089C86.1895 96.1527 88.5878 96.0386 90.7038 95.9378C96.0128 95.685 98.362 95.51 98.4077 94.0103C98.4123 93.8636 98.4258 93.4172 97.7467 92.8971C94.0652 90.0783 77.9203 90.5404 71.5266 92.4787C71.4384 92.5029 69.7089 92.9759 63.5168 94.3489C61.2833 94.8398 56.0519 96.8089 55.6879 104.481V104.481Z"
              fill="#222433"/>
        <path d="M151.796 175.679C151.475 175.582 151.13 175.617 150.835 175.775C150.54 175.933 150.32 176.202 150.222 176.522L148.905 180.87C148.828 181.128 148.687 181.363 148.497 181.553C148.307 181.744 148.073 181.884 147.815 181.963L143.47 183.277C143.209 183.354 142.979 183.513 142.816 183.73C142.653 183.948 142.564 184.212 142.563 184.484C142.562 184.756 142.65 185.021 142.812 185.24C142.974 185.458 143.202 185.619 143.462 185.697L147.815 187.014C148.073 187.091 148.308 187.231 148.499 187.422C148.689 187.613 148.829 187.848 148.905 188.106L148.932 188.193L149.698 186.591C149.315 186.132 148.806 185.796 148.233 185.624L144.475 184.488L148.236 183.352C148.722 183.205 149.164 182.939 149.523 182.58C149.882 182.221 150.147 181.779 150.295 181.293L151.431 177.537L152.439 180.865L153.367 178.925L152.639 176.522C152.579 176.323 152.471 176.142 152.324 175.994C152.176 175.847 151.995 175.739 151.796 175.679Z"
              fill="#222433"/>
        <path d="M170.198 141.716L168.881 137.361C168.801 137.103 168.64 136.877 168.422 136.717C168.204 136.557 167.941 136.471 167.671 136.472C167.4 136.472 167.137 136.56 166.92 136.72C166.703 136.881 166.543 137.108 166.464 137.366L165.149 141.714C165.071 141.973 164.931 142.208 164.74 142.399C164.549 142.59 164.313 142.731 164.054 142.809L159.699 144.126C159.503 144.187 159.325 144.295 159.18 144.44C159.036 144.585 158.928 144.764 158.868 144.96C158.817 145.118 158.799 145.285 158.815 145.45C158.83 145.615 158.878 145.776 158.957 145.922C159.034 146.07 159.14 146.201 159.268 146.307C159.396 146.414 159.545 146.494 159.704 146.543L164.057 147.86C164.315 147.938 164.55 148.078 164.741 148.269C164.932 148.459 165.072 148.694 165.149 148.953L166.138 152.22L167.066 150.282L166.537 148.532C166.39 148.045 166.125 147.601 165.765 147.241C165.406 146.882 164.962 146.617 164.475 146.47L160.717 145.334L164.475 144.198C164.962 144.051 165.405 143.785 165.765 143.425C166.124 143.065 166.389 142.622 166.537 142.134L167.673 138.379L168.811 142.134C169.026 142.854 169.497 143.469 170.135 143.865L170.28 143.563C170.28 143.563 170.486 143.205 170.827 142.581C170.525 142.372 170.304 142.068 170.198 141.716Z"
              fill="#222433"/>
        <path d="M393.359 228.535H13.7215C13.5292 228.535 13.3448 228.459 13.2088 228.323C13.0729 228.187 12.9965 228.003 12.9965 227.81C12.9965 227.618 13.0729 227.434 13.2088 227.298C13.3448 227.162 13.5292 227.085 13.7215 227.085H393.359C393.551 227.085 393.736 227.162 393.872 227.298C394.008 227.434 394.084 227.618 394.084 227.81C394.084 228.003 394.008 228.187 393.872 228.323C393.736 228.459 393.551 228.535 393.359 228.535Z"
              fill="#222433"/>
        <path d="M37.383 100.572C37.2838 100.572 37.1855 100.552 37.0945 100.512C37.0034 100.473 36.9214 100.415 36.8536 100.343C36.7858 100.27 36.7336 100.184 36.7002 100.091C36.6668 99.9974 36.653 99.8981 36.6597 99.799L37.6023 85.4934C37.6085 85.3983 37.6334 85.3055 37.6756 85.2201C37.7177 85.1347 37.7763 85.0584 37.8479 84.9956C37.9925 84.8689 38.1816 84.8047 38.3735 84.8174C38.4685 84.8236 38.5614 84.8485 38.6468 84.8907C38.7322 84.9328 38.8085 84.9914 38.8712 85.063C38.934 85.1346 38.982 85.2179 39.0126 85.3081C39.0432 85.3982 39.0558 85.4936 39.0495 85.5886L38.1714 98.9152L61.7976 93.327C61.9848 93.2828 62.1818 93.3147 62.3455 93.4157C62.5091 93.5167 62.6259 93.6786 62.6701 93.8658C62.7144 94.0529 62.6825 94.25 62.5815 94.4136C62.4804 94.5772 62.3186 94.694 62.1314 94.7383L37.55 100.553C37.4953 100.566 37.4393 100.572 37.383 100.572Z"
              fill="#222433"/>
        <path d="M45.4543 228.526H11.8509C11.1664 228.526 10.4832 228.467 9.80881 228.35C6.71461 227.81 3.96143 226.064 2.15493 223.494C0.348437 220.925 -0.363405 217.743 0.176003 214.649L5.92823 181.537C6.40002 178.786 7.83059 176.29 9.96646 174.493C12.1023 172.695 14.8056 171.711 17.5973 171.716H39.7023C42.494 171.711 45.1974 172.695 47.3332 174.493C49.4691 176.29 50.8997 178.786 51.3713 181.538L57.1211 214.65C57.2383 215.324 57.2972 216.007 57.2971 216.691C57.2949 219.831 56.0461 222.841 53.8254 225.06C51.6047 227.279 48.5937 228.526 45.4543 228.526ZM11.8504 227.076H45.4535C48.2086 227.076 50.8508 225.982 52.7996 224.034C54.7484 222.087 55.8442 219.445 55.8462 216.69C55.8463 216.09 55.7947 215.49 55.6918 214.898L49.9417 181.786C49.5279 179.372 48.2726 177.181 46.3983 175.604C44.5239 174.026 42.1515 173.163 39.7016 173.167C39.6995 173.167 39.6975 173.167 39.6955 173.167H17.5973C15.1473 173.163 12.7749 174.026 10.9005 175.603C9.02611 177.181 7.77074 179.371 7.35686 181.786L1.60463 214.898C1.37017 216.242 1.40284 217.62 1.70078 218.952C1.99872 220.284 2.55608 221.544 3.34106 222.66C4.12603 223.777 5.12323 224.728 6.27573 225.459C7.42823 226.19 8.71344 226.687 10.058 226.921C10.6505 227.02 11.2498 227.071 11.8504 227.076Z"
              fill="#222433"/>
        <path d="M22.9053 222.266C21.8821 222.27 20.8883 221.924 20.0877 221.287C19.2871 220.65 18.7276 219.759 18.5014 218.761L17.0706 212.577C16.9178 211.914 16.9164 211.226 17.0666 210.563C17.2167 209.9 17.5145 209.279 17.9377 208.747C18.361 208.214 18.8988 207.784 19.5112 207.489C20.1236 207.193 20.7947 207.04 21.4747 207.039H35.3407C36.0208 207.04 36.692 207.193 37.3045 207.489C37.9169 207.784 38.4548 208.214 38.8781 208.747C39.3014 209.279 39.5992 209.9 39.7493 210.563C39.8994 211.226 39.8979 211.915 39.745 212.578L38.3142 218.763C38.0872 219.76 37.5274 220.65 36.7269 221.287C35.9264 221.924 34.933 222.269 33.9102 222.266H22.9053ZM21.475 208.49C21.013 208.49 20.5571 208.594 20.1411 208.795C19.7251 208.996 19.3598 209.288 19.0723 209.65C18.7848 210.011 18.5826 210.433 18.4807 210.883C18.3787 211.334 18.3797 211.802 18.4836 212.252L19.9144 218.436C20.068 219.114 20.4481 219.719 20.992 220.151C21.5358 220.584 22.2108 220.818 22.9058 220.816H33.9097C34.6045 220.818 35.2793 220.583 35.8231 220.151C36.3669 219.718 36.7471 219.114 36.9013 218.436L38.3321 212.251C38.4359 211.801 38.4368 211.333 38.3348 210.883C38.2328 210.432 38.0306 210.011 37.743 209.649C37.4555 209.288 37.0902 208.996 36.6742 208.795C36.2583 208.594 35.8024 208.49 35.3405 208.49H21.475Z"
              fill="#222433"/>
        <path d="M37.6271 185.14H19.1862C18.9939 185.14 18.8094 185.063 18.6735 184.928C18.5375 184.792 18.4611 184.607 18.4611 184.415C18.4611 184.223 18.5375 184.038 18.6735 183.902C18.8094 183.766 18.9939 183.69 19.1862 183.69H37.6271C37.8194 183.69 38.0039 183.766 38.1398 183.902C38.2758 184.038 38.3522 184.223 38.3522 184.415C38.3522 184.607 38.2758 184.792 38.1398 184.928C38.0039 185.063 37.8194 185.14 37.6271 185.14Z"
              fill="#222433"/>
        <path d="M25.9777 202.844C24.7611 202.844 23.5719 202.483 22.5603 201.807C21.5488 201.131 20.7604 200.171 20.2948 199.047C19.8293 197.923 19.7075 196.686 19.9448 195.493C20.1822 194.3 20.768 193.204 21.6282 192.343C22.4885 191.483 23.5845 190.897 24.7776 190.66C25.9708 190.423 27.2076 190.544 28.3315 191.01C29.4555 191.475 30.4162 192.264 31.092 193.275C31.7679 194.287 32.1287 195.476 32.1287 196.693C32.1268 198.323 31.4782 199.887 30.325 201.04C29.1719 202.193 27.6084 202.842 25.9777 202.844ZM25.9777 191.992C25.0479 191.992 24.139 192.268 23.366 192.784C22.5929 193.301 21.9904 194.035 21.6346 194.894C21.2788 195.753 21.1857 196.698 21.3671 197.61C21.5485 198.522 21.9962 199.359 22.6536 200.017C23.3111 200.674 24.1487 201.122 25.0606 201.303C25.9724 201.485 26.9176 201.392 27.7766 201.036C28.6356 200.68 29.3697 200.077 29.8863 199.304C30.4028 198.531 30.6785 197.622 30.6785 196.693C30.6771 195.446 30.1814 194.252 29.3001 193.37C28.4188 192.489 27.224 191.993 25.9777 191.992Z"
              fill="#222433"/>
        <path d="M325.379 228.173C325.268 228.173 325.158 228.147 325.059 228.098C324.959 228.049 324.872 227.978 324.804 227.89C324.736 227.802 324.69 227.699 324.668 227.59C324.646 227.481 324.65 227.369 324.678 227.261L346.198 146.358C346.248 146.172 346.369 146.013 346.536 145.917C346.702 145.82 346.9 145.794 347.086 145.843C347.272 145.893 347.43 146.014 347.527 146.181C347.623 146.347 347.65 146.545 347.6 146.731L326.079 227.634C326.038 227.788 325.947 227.925 325.82 228.022C325.694 228.12 325.539 228.173 325.379 228.173Z"
              fill="#222433"/>
        <path d="M315.743 141.945L389.117 141.938V142.905C389.117 143.807 388.759 144.673 388.121 145.311C387.482 145.949 386.617 146.307 385.714 146.307H312.202L315.743 141.945Z"
              fill="#222433"/>
        <path d="M387.907 143.864C387.859 143.864 387.812 143.859 387.765 143.85C387.671 143.831 387.583 143.795 387.503 143.742C387.424 143.689 387.356 143.621 387.303 143.541C387.251 143.462 387.214 143.373 387.195 143.28C387.177 143.187 387.177 143.09 387.195 142.997L398.391 86.8116C398.631 85.5997 398.6 84.3495 398.3 83.151C397.999 81.9526 397.437 80.8357 396.653 79.8807C395.869 78.9258 394.883 78.1565 393.766 77.6284C392.649 77.1002 391.428 76.8263 390.193 76.8264H385.345C385.152 76.8264 384.968 76.75 384.832 76.614C384.696 76.478 384.62 76.2936 384.62 76.1013C384.62 75.909 384.696 75.7246 384.832 75.5886C384.968 75.4526 385.152 75.3762 385.345 75.3762H390.193C391.643 75.3763 393.075 75.6979 394.385 76.3178C395.696 76.9376 396.853 77.8404 397.773 78.9611C398.693 80.0817 399.353 81.3924 399.706 82.7988C400.058 84.2052 400.095 85.6722 399.812 87.0943L388.618 143.282C388.585 143.446 388.496 143.593 388.366 143.7C388.237 143.806 388.075 143.864 387.907 143.864Z"
              fill="#222433"/>
        <path d="M392.577 228.173C392.404 228.173 392.237 228.11 392.106 227.997C391.974 227.885 391.888 227.728 391.862 227.557L379.535 146.654C379.52 146.559 379.524 146.463 379.547 146.37C379.569 146.277 379.61 146.189 379.666 146.112C379.723 146.035 379.794 145.97 379.876 145.92C379.958 145.871 380.048 145.838 380.143 145.824C380.237 145.809 380.334 145.814 380.426 145.837C380.519 145.86 380.607 145.901 380.683 145.958C380.76 146.015 380.825 146.086 380.874 146.169C380.923 146.251 380.955 146.342 380.969 146.436L393.295 227.34C393.31 227.434 393.305 227.53 393.283 227.622C393.26 227.715 393.219 227.802 393.163 227.878C393.106 227.955 393.035 228.02 392.954 228.069C392.872 228.119 392.782 228.151 392.688 228.166C392.651 228.171 392.614 228.173 392.577 228.173Z"
              fill="#222433"/>
        <path d="M316.83 81.1224L327.695 63.3985C329.047 60.7228 331.094 58.4603 333.621 56.8489C336.149 55.2374 339.064 54.3363 342.06 54.2404L345.394 54.1323C345.394 54.1323 344.744 64.0948 355.029 64.4767C364.958 64.8445 364.05 53.5281 364.05 53.5281L367.438 53.4184C371.205 53.2966 374.902 54.4526 377.929 56.6984C380.956 58.9443 383.134 62.1478 384.109 65.7883C384.97 67.9426 385.364 70.2546 385.267 72.5723L386.118 116.347C385.998 119.888 384.508 123.243 381.962 125.705C379.415 128.168 376.012 129.545 372.47 129.546H372.446C370.492 129.545 368.561 129.126 366.783 128.316L326.959 110.584C326.959 110.584 341.557 115.708 345.192 99.3647C346.204 81.2887 329.46 84.6049 329.46 84.6049L316.83 81.1224Z"
              fill="#2E7D32"/>
        <path d="M302.806 81.207C302.649 81.2073 302.496 81.1564 302.371 81.062L299.67 79.0318C297.713 77.5568 295.376 76.6703 292.933 76.4761C292.838 76.4686 292.745 76.4425 292.661 76.3992C292.576 76.356 292.5 76.2964 292.438 76.224C292.314 76.0777 292.252 75.8878 292.267 75.6961C292.275 75.6011 292.301 75.5086 292.344 75.4238C292.387 75.3389 292.447 75.2635 292.519 75.2016C292.665 75.0768 292.855 75.0152 293.047 75.0303C295.765 75.2461 298.364 76.2322 300.541 77.8729L303.242 79.9031C303.364 79.9944 303.454 80.1219 303.499 80.2673C303.545 80.4127 303.543 80.5686 303.495 80.7131C303.447 80.8575 303.354 80.9831 303.23 81.072C303.107 81.1608 302.958 81.2085 302.806 81.2082L302.806 81.207Z"
              fill="#222433"/>
        <path d="M325.422 83.8784C325.381 83.8784 325.34 83.8749 325.3 83.868C325.11 83.8356 324.941 83.7293 324.83 83.5724C324.719 83.4154 324.675 83.2208 324.707 83.0313L325.943 75.7883C325.958 75.6934 325.991 75.6024 326.041 75.5206C326.092 75.4388 326.158 75.3679 326.236 75.3118C326.314 75.2558 326.402 75.2158 326.496 75.1941C326.589 75.1725 326.686 75.1697 326.781 75.1859C326.876 75.202 326.966 75.2368 327.047 75.2882C327.128 75.3397 327.198 75.4067 327.253 75.4854C327.308 75.5642 327.347 75.653 327.368 75.7469C327.388 75.8407 327.389 75.9377 327.372 76.0322L326.136 83.2751C326.108 83.4437 326.02 83.5968 325.889 83.7072C325.759 83.8176 325.593 83.8782 325.422 83.8784Z"
              fill="#222433"/>
        <path d="M349.178 50.2065C347.705 50.2058 346.239 49.9951 344.825 49.5808C344.733 49.555 344.646 49.5111 344.571 49.4516C344.496 49.3922 344.433 49.3184 344.386 49.2346C344.34 49.1507 344.31 49.0585 344.3 48.9631C344.289 48.8678 344.297 48.7713 344.324 48.6792C344.351 48.5872 344.396 48.5013 344.456 48.4267C344.517 48.3521 344.591 48.2902 344.675 48.2446C344.76 48.199 344.852 48.1706 344.948 48.161C345.043 48.1515 345.14 48.161 345.231 48.1889C347.237 48.7794 349.349 48.9113 351.413 48.5748C353.476 48.2383 355.437 47.4421 357.151 46.245C357.309 46.1352 357.504 46.0926 357.693 46.1266C357.882 46.1606 358.05 46.2684 358.16 46.4263C358.27 46.5841 358.312 46.7792 358.278 46.9685C358.244 47.1577 358.137 47.3258 357.979 47.4356C355.398 49.2376 352.326 50.2047 349.178 50.2065Z"
              fill="#222433"/>
        <path d="M354.784 65.2042C352.179 65.2 349.678 64.1813 347.812 62.3643C345.946 60.5472 344.861 58.0746 344.787 55.4708L344.623 49.5146C342.45 48.8436 340.452 47.6994 338.773 46.1643C337.094 44.6291 335.776 42.7411 334.914 40.636C334.052 38.5309 333.667 36.261 333.787 33.9893C333.906 31.7176 334.528 29.5007 335.606 27.4978C335.699 27.3307 335.854 27.2069 336.037 27.1532C336.22 27.0995 336.417 27.1203 336.585 27.2111C336.753 27.3018 336.879 27.4552 336.934 27.6379C336.99 27.8206 336.971 28.0179 336.882 28.1869C335.886 30.0376 335.321 32.0895 335.229 34.1894C335.137 36.2892 335.521 38.3827 336.352 40.3133C337.182 42.244 338.439 43.962 340.027 45.339C341.615 46.716 343.493 47.7163 345.522 48.2653C345.673 48.306 345.806 48.3941 345.903 48.5166C345.999 48.6391 346.054 48.7895 346.058 48.9454L346.236 55.4312C346.297 57.6788 347.241 59.812 348.864 61.3687C350.486 62.9253 352.656 63.7802 354.905 63.748C357.153 63.7158 359.298 62.7992 360.875 61.1968C362.452 59.5943 363.335 57.435 363.331 55.1866L363.25 34.7224C363.249 34.6272 363.267 34.5328 363.304 34.4447C363.34 34.3565 363.393 34.2764 363.46 34.2088C363.527 34.1412 363.607 34.0875 363.695 34.0507C363.782 34.0139 363.877 33.9948 363.972 33.9945C364.067 33.9931 364.162 34.0108 364.251 34.0466C364.339 34.0823 364.42 34.1354 364.488 34.2026C364.555 34.2699 364.609 34.35 364.645 34.4382C364.682 34.5265 364.7 34.6211 364.7 34.7166L364.782 55.1825C364.801 57.7961 363.79 60.3122 361.969 62.1869C360.148 64.0615 357.662 65.1441 355.049 65.2005C354.961 65.203 354.872 65.2042 354.784 65.2042Z"
              fill="#222433"/>
        <path d="M336.468 21.8788C336.02 18.9258 336.442 15.9061 337.684 13.1895C337.723 13.1029 337.78 13.025 337.849 12.9602C337.919 12.8954 338.001 12.8449 338.09 12.8117C338.18 12.7785 338.275 12.7633 338.37 12.7668C338.465 12.7703 338.558 12.7925 338.645 12.8322C338.732 12.8719 338.81 12.9282 338.874 12.998C338.939 13.0678 338.99 13.1497 339.023 13.239C339.056 13.3283 339.071 13.4232 339.068 13.5184C339.064 13.6136 339.042 13.7072 339.002 13.7938C337.879 16.2509 337.496 18.9822 337.901 21.6535L337.185 21.7729L336.468 21.8788Z"
              fill="#222433"/>
        <path d="M341.45 29.5421C341.344 29.5421 341.239 29.5187 341.143 29.4737C341.047 29.4286 340.962 29.363 340.893 29.2814C340.825 29.1999 340.776 29.1043 340.749 29.0016C340.722 28.8989 340.718 28.7915 340.737 28.687L341.936 22.1106C341.95 22.0146 341.984 21.9226 342.035 21.8399C342.086 21.7572 342.152 21.6855 342.231 21.6291C342.31 21.5728 342.4 21.5328 342.495 21.5116C342.589 21.4905 342.687 21.4886 342.783 21.506C342.878 21.5234 342.969 21.5598 343.05 21.613C343.131 21.6662 343.201 21.7352 343.255 21.8158C343.309 21.8965 343.346 21.9871 343.365 22.0824C343.383 22.1777 343.382 22.2757 343.362 22.3706L342.328 28.0402L345.565 27.8539C345.661 27.8478 345.756 27.8606 345.847 27.8916C345.937 27.9226 346.021 27.9712 346.092 28.0346C346.164 28.098 346.222 28.1749 346.264 28.261C346.306 28.347 346.33 28.4404 346.335 28.5359C346.341 28.6313 346.328 28.727 346.296 28.8172C346.264 28.9074 346.215 28.9905 346.151 29.0617C346.087 29.1329 346.01 29.1907 345.924 29.2319C345.837 29.273 345.744 29.2967 345.648 29.3016L341.491 29.5409C341.479 29.5421 341.465 29.5421 341.45 29.5421Z"
              fill="#222433"/>
        <path d="M349.415 25.4357C350.269 25.4357 350.962 24.7432 350.962 23.8889C350.962 23.0346 350.269 22.3421 349.415 22.3421C348.561 22.3421 347.868 23.0346 347.868 23.8889C347.868 24.7432 348.561 25.4357 349.415 25.4357Z"
              fill="#222433"/>
        <path d="M338.611 25.3874C339.466 25.3874 340.158 24.6949 340.158 23.8406C340.158 22.9863 339.466 22.2938 338.611 22.2938C337.757 22.2938 337.065 22.9863 337.065 23.8406C337.065 24.6949 337.757 25.3874 338.611 25.3874Z"
              fill="#222433"/>
        <path d="M337.019 28.6381C333.912 28.6381 331.385 25.768 331.385 22.2406C331.385 22.0483 331.461 21.8638 331.597 21.7279C331.733 21.5919 331.918 21.5155 332.11 21.5155H341.922C342.115 21.5155 342.299 21.5919 342.435 21.7279C342.571 21.8638 342.648 22.0483 342.648 22.2406C342.648 25.768 340.122 28.6381 337.019 28.6381ZM332.88 22.9656C333.177 25.3511 334.92 27.188 337.019 27.188C339.117 27.188 340.855 25.3511 341.153 22.9656H332.88Z"
              fill="#222433"/>
        <path d="M349.927 28.6381C346.823 28.6381 344.298 25.768 344.298 22.2406C344.298 22.0483 344.375 21.8638 344.511 21.7279C344.647 21.5919 344.831 21.5155 345.023 21.5155H354.829C355.021 21.5155 355.205 21.5919 355.341 21.7279C355.477 21.8638 355.554 22.0483 355.554 22.2406C355.554 25.768 353.03 28.6381 349.927 28.6381ZM345.793 22.9656C346.09 25.3511 347.831 27.188 349.927 27.188C352.023 27.188 353.762 25.3511 354.06 22.9656H345.793Z"
              fill="#222433"/>
        <path d="M358.626 22.9656H341.45C341.258 22.9656 341.074 22.8893 340.938 22.7533C340.802 22.6173 340.725 22.4329 340.725 22.2406C340.725 22.0483 340.802 21.8638 340.938 21.7279C341.074 21.5919 341.258 21.5155 341.45 21.5155H358.625C358.817 21.5155 359.001 21.5919 359.137 21.7279C359.273 21.8638 359.35 22.0483 359.35 22.2406C359.35 22.4329 359.273 22.6173 359.137 22.7533C359.001 22.8893 358.817 22.9656 358.625 22.9656H358.626Z"
              fill="#222433"/>
        <path d="M344.193 39.5541C342.109 39.5541 339.925 37.9625 339.539 34.2973C339.529 34.2023 339.538 34.1062 339.565 34.0146C339.592 33.9229 339.637 33.8376 339.697 33.7635C339.758 33.6894 339.832 33.6279 339.916 33.5826C340 33.5374 340.093 33.5092 340.188 33.4997L348.27 32.6949C348.369 32.6849 348.469 32.6954 348.564 32.7258C348.659 32.7562 348.747 32.8059 348.821 32.8716C348.896 32.9374 348.957 33.0179 348.999 33.1081C349.041 33.1983 349.065 33.2962 349.068 33.3958C349.179 37.2227 346.838 39.3861 344.468 39.5454C344.376 39.5509 344.284 39.5541 344.193 39.5541ZM341.089 34.8672C341.585 37.3648 343.122 38.1817 344.37 38.0979C345.891 37.9956 347.392 36.6405 347.597 34.219L341.089 34.8672Z"
              fill="#222433"/>
        <path d="M357.324 27.5602C357.211 27.5604 357.099 27.5339 356.997 27.4827C356.896 27.4316 356.808 27.3573 356.74 27.2658C356.11 26.4173 355.782 25.3824 355.808 24.3259L355.965 16.8987C355.978 16.2977 355.752 15.716 355.337 15.2811C354.922 14.8462 354.351 14.5935 353.75 14.5785L335.865 14.158C333.995 14.145 332.206 13.3923 330.888 12.0643C329.571 10.7363 328.833 8.94094 328.835 7.07046C328.837 5.19997 329.58 3.40641 330.9 2.0816C332.221 0.756788 334.012 0.00842453 335.882 0H357.97C360.392 0.00287949 362.714 0.96641 364.426 2.67917C366.139 4.39193 367.102 6.71401 367.104 9.13589V18.4651C367.104 18.6574 367.028 18.8419 366.892 18.9778C366.756 19.1138 366.571 19.1902 366.379 19.1902C366.187 19.1902 366.002 19.1138 365.866 18.9778C365.73 18.8419 365.654 18.6574 365.654 18.4651V9.13589C365.654 8.12687 365.456 7.12765 365.07 6.19529C364.684 5.26294 364.118 4.41572 363.405 3.70202C362.692 2.98832 361.845 2.42211 360.913 2.03573C359.981 1.64935 358.982 1.45036 357.973 1.45014H335.882C334.389 1.45014 332.958 2.04319 331.902 3.09883C330.846 4.15446 330.253 5.58621 330.253 7.07911C330.253 8.572 330.846 10.0038 331.902 11.0594C332.958 12.115 334.389 12.7081 335.882 12.7081L353.784 13.1286C354.769 13.1537 355.704 13.5676 356.384 14.2799C357.064 14.9922 357.434 15.9448 357.414 16.9294L357.257 24.3559C357.239 25.0918 357.468 25.8126 357.906 26.4037C357.986 26.5116 358.034 26.6395 358.046 26.7732C358.057 26.9068 358.031 27.041 357.971 27.1608C357.91 27.2806 357.818 27.3813 357.704 27.4517C357.589 27.522 357.458 27.5594 357.324 27.5595L357.324 27.5602Z"
              fill="#222433"/>
        <path d="M294.382 228.173C294.248 228.173 294.116 228.136 294.002 228.065C293.888 227.995 293.795 227.895 293.735 227.775C293.674 227.656 293.648 227.522 293.659 227.388C293.67 227.255 293.718 227.127 293.797 227.019L307.661 208.123C307.736 208.021 307.837 207.94 307.953 207.888C308.07 207.837 308.198 207.818 308.324 207.831C308.451 207.845 308.572 207.892 308.674 207.967C308.777 208.043 308.858 208.144 308.909 208.26L313.082 217.739L324.419 212.579L313.47 188.466C313.431 188.379 313.409 188.286 313.405 188.19C313.402 188.095 313.417 188 313.451 187.91C313.484 187.821 313.535 187.739 313.6 187.67C313.665 187.6 313.743 187.544 313.83 187.504C313.917 187.465 314.011 187.443 314.106 187.44C314.201 187.437 314.296 187.452 314.386 187.486C314.475 187.52 314.557 187.57 314.626 187.636C314.696 187.701 314.752 187.779 314.791 187.866L326.038 212.64C326.117 212.815 326.124 213.014 326.057 213.194C325.989 213.374 325.853 213.52 325.678 213.599L313.013 219.364C312.926 219.403 312.832 219.425 312.736 219.428C312.64 219.431 312.544 219.415 312.455 219.381C312.365 219.347 312.283 219.295 312.214 219.229C312.144 219.163 312.088 219.084 312.05 218.996L308.086 209.994L294.965 227.877C294.898 227.969 294.81 228.043 294.709 228.094C294.607 228.146 294.495 228.173 294.382 228.173Z"
              fill="#222433"/>
        <path d="M257.968 228.173C257.787 228.173 257.613 228.105 257.48 227.983C257.347 227.861 257.263 227.694 257.247 227.514C256.589 220.322 260.464 214.694 267.611 212.46C273.961 210.478 277.814 206.848 278.753 201.965C278.79 201.777 278.9 201.611 279.059 201.504C279.218 201.397 279.413 201.357 279.601 201.393C279.79 201.43 279.956 201.539 280.064 201.697C280.172 201.856 280.213 202.051 280.177 202.239C279.147 207.602 274.838 211.723 268.044 213.844C261.501 215.89 258.092 220.824 258.691 227.382C258.708 227.573 258.649 227.764 258.526 227.912C258.403 228.059 258.226 228.152 258.035 228.17C258.013 228.172 257.99 228.173 257.968 228.173Z"
              fill="#222433"/>
        <path d="M251.111 149.225C250.974 149.225 250.84 149.187 250.724 149.114C250.608 149.041 250.515 148.937 250.456 148.813L241.699 130.504C239.511 125.618 239.682 120.033 242.174 114.761C245.212 108.332 251.375 103.172 258.258 101.291C259.546 100.939 260.862 100.697 262.191 100.566C262.286 100.556 262.382 100.564 262.474 100.591C262.566 100.619 262.652 100.664 262.726 100.724C262.8 100.785 262.862 100.859 262.907 100.944C262.953 101.028 262.981 101.121 262.99 101.216C263 101.311 262.99 101.408 262.962 101.499C262.934 101.591 262.888 101.676 262.827 101.75C262.766 101.824 262.69 101.884 262.605 101.929C262.521 101.973 262.428 102.001 262.332 102.009C261.085 102.132 259.849 102.359 258.64 102.69C252.154 104.462 246.347 109.325 243.485 115.381C241.177 120.263 241.01 125.418 243.015 129.895L251.764 148.187C251.817 148.298 251.842 148.42 251.835 148.542C251.828 148.664 251.79 148.783 251.725 148.887C251.66 148.991 251.569 149.076 251.462 149.136C251.355 149.195 251.234 149.226 251.112 149.226L251.111 149.225Z"
              fill="#222433"/>
        <path d="M277.186 203.743C277.049 203.743 276.915 203.704 276.799 203.631C276.684 203.558 276.591 203.454 276.532 203.33L271.897 193.641C271.854 193.555 271.829 193.461 271.823 193.365C271.817 193.269 271.83 193.173 271.861 193.082C271.892 192.991 271.942 192.907 272.006 192.836C272.069 192.764 272.147 192.706 272.234 192.664C272.32 192.623 272.414 192.599 272.51 192.594C272.606 192.589 272.702 192.604 272.793 192.636C272.883 192.669 272.966 192.719 273.037 192.784C273.108 192.849 273.165 192.928 273.205 193.015L277.546 202.091L319.975 185.036L305.586 153.674C305.544 153.587 305.52 153.493 305.515 153.397C305.51 153.3 305.524 153.204 305.556 153.113C305.589 153.023 305.639 152.939 305.705 152.868C305.77 152.797 305.849 152.74 305.936 152.7C306.024 152.659 306.119 152.637 306.215 152.634C306.312 152.631 306.408 152.647 306.498 152.682C306.588 152.716 306.67 152.768 306.74 152.835C306.81 152.902 306.865 152.982 306.904 153.07L321.61 185.123C321.651 185.212 321.673 185.309 321.676 185.407C321.678 185.505 321.661 185.603 321.625 185.694C321.588 185.785 321.534 185.868 321.464 185.937C321.395 186.007 321.313 186.061 321.221 186.098L277.456 203.691C277.37 203.725 277.279 203.743 277.186 203.743Z"
              fill="#222433"/>
        <path d="M246.445 228.543C246.338 228.543 246.233 228.519 246.136 228.473L233.544 222.547C233.457 222.506 233.38 222.449 233.315 222.378C233.251 222.306 233.201 222.223 233.169 222.133C233.137 222.042 233.124 221.946 233.129 221.85C233.134 221.755 233.159 221.661 233.201 221.574L237.501 212.717L216.121 214.233C215.997 214.241 215.873 214.218 215.761 214.165L182.407 198.477C182.243 198.4 182.113 198.263 182.045 198.095C181.976 197.927 181.973 197.739 182.037 197.568C183.197 194.429 185.435 191.805 188.351 190.163C191.267 188.522 194.672 187.971 197.957 188.608C198.555 188.648 205.262 189.089 213.135 189.017C216.782 188.983 220.004 188.267 222.711 186.89C222.882 186.803 223.081 186.788 223.263 186.848C223.445 186.908 223.596 187.038 223.683 187.209C223.77 187.379 223.786 187.578 223.727 187.76C223.668 187.943 223.539 188.095 223.368 188.182C220.46 189.662 217.021 190.43 213.148 190.466C204.878 190.543 197.881 190.055 197.811 190.051C197.782 190.049 197.752 190.045 197.724 190.039C194.882 189.478 191.935 189.909 189.372 191.258C186.81 192.608 184.788 194.795 183.643 197.456L216.206 212.772L238.649 211.181C238.776 211.172 238.903 211.196 239.017 211.252C239.132 211.307 239.229 211.392 239.301 211.497C239.372 211.603 239.414 211.725 239.423 211.852C239.433 211.978 239.408 212.105 239.353 212.22L234.825 221.546L246.098 226.852L252.418 213.457C252.501 213.285 252.649 213.153 252.829 213.09C253.009 213.027 253.207 213.037 253.379 213.118C253.552 213.199 253.685 213.346 253.751 213.525C253.816 213.704 253.808 213.902 253.729 214.076L247.1 228.125C247.042 228.25 246.949 228.355 246.833 228.429C246.717 228.503 246.582 228.542 246.445 228.543Z"
              fill="#222433"/>
        <path d="M304.351 101.955H235.058C234.885 101.955 234.717 101.893 234.586 101.78C234.454 101.667 234.367 101.51 234.341 101.339L228.596 63.5651C228.547 63.2381 228.522 62.9079 228.522 62.5773C228.522 60.841 229.212 59.176 230.44 57.9484C231.668 56.7208 233.333 56.0312 235.069 56.0313H285.025C286.593 56.0235 288.111 56.582 289.301 57.6041C290.49 58.6263 291.27 60.0434 291.498 61.5948L296.789 96.4033H308.975C309.168 96.4033 309.352 96.4797 309.488 96.6157C309.624 96.7516 309.7 96.9361 309.7 97.1284C309.7 97.3207 309.624 97.5051 309.488 97.6411C309.352 97.777 309.168 97.8534 308.975 97.8534H296.166C295.992 97.8534 295.825 97.7912 295.693 97.6782C295.562 97.5652 295.475 97.4088 295.449 97.2374L290.064 61.8128C289.887 60.6049 289.279 59.5016 288.353 58.7058C287.428 57.9101 286.246 57.4753 285.025 57.4815H235.07C233.718 57.4815 232.422 58.0183 231.466 58.974C230.51 59.9297 229.973 61.2258 229.973 62.5775C229.973 62.835 229.992 63.0922 230.031 63.3468L235.682 100.505H304.351C304.543 100.505 304.728 100.581 304.863 100.717C304.999 100.853 305.076 101.038 305.076 101.23C305.076 101.422 304.999 101.607 304.863 101.743C304.728 101.879 304.543 101.955 304.351 101.955Z"
              fill="#222433"/>
        <path d="M262.636 85.5753C264.173 84.0836 263.958 81.3675 262.155 79.5089C260.352 77.6502 257.644 77.3527 256.106 78.8444C254.568 80.3361 254.783 83.0522 256.586 84.9108C258.39 86.7695 261.098 87.067 262.636 85.5753Z"
              fill="#222222"/>
        <path d="M359.484 95.7C359.379 95.7 359.276 95.6774 359.181 95.6337L338.309 86.0606C338.136 85.9792 338.003 85.833 337.937 85.6536C337.871 85.4742 337.879 85.2762 337.959 85.1025C338.038 84.9289 338.183 84.7937 338.362 84.7263C338.541 84.6589 338.739 84.6647 338.913 84.7424L358.892 93.9059L360.698 80.1279C360.71 80.0331 360.74 79.9416 360.788 79.8586C360.835 79.7757 360.899 79.7029 360.974 79.6445C361.05 79.5861 361.136 79.5432 361.228 79.5183C361.321 79.4934 361.417 79.487 361.512 79.4994C361.606 79.5118 361.698 79.5428 361.78 79.5907C361.863 79.6385 361.936 79.7022 361.994 79.7781C362.052 79.8541 362.094 79.9407 362.118 80.0331C362.143 80.1254 362.149 80.2217 362.136 80.3164L360.202 95.0692C360.179 95.2437 360.094 95.4039 359.962 95.5199C359.829 95.636 359.659 95.7 359.483 95.7H359.484Z"
              fill="#222433"/>
        <path d="M332.556 111.928C331.972 111.928 331.389 111.887 330.811 111.804C326.016 111.123 322.015 107.656 320.37 102.756C320.34 102.666 320.328 102.571 320.334 102.476C320.341 102.381 320.366 102.288 320.408 102.203C320.451 102.117 320.51 102.041 320.581 101.979C320.653 101.916 320.737 101.869 320.827 101.838C320.917 101.808 321.012 101.796 321.107 101.802C321.202 101.809 321.295 101.834 321.38 101.876C321.466 101.919 321.542 101.978 321.604 102.049C321.667 102.121 321.715 102.205 321.745 102.295C323.214 106.671 326.767 109.765 331.015 110.369C334.114 110.809 337.219 109.904 339.757 107.821C342.323 105.641 344.002 102.597 344.475 99.2631C344.949 95.9296 344.186 92.538 342.329 89.7293C340.472 87.0212 337.742 85.287 334.643 84.8472C332.979 84.6088 331.283 84.7618 329.689 85.294C329.598 85.3239 329.503 85.3357 329.408 85.3287C329.313 85.3217 329.22 85.296 329.135 85.2532C329.05 85.2104 328.974 85.1512 328.912 85.0791C328.85 85.0069 328.802 84.9232 328.772 84.8328C328.742 84.7423 328.731 84.6469 328.738 84.5519C328.745 84.4568 328.77 84.3641 328.813 84.2791C328.856 84.194 328.915 84.1181 328.987 84.0559C329.059 83.9937 329.143 83.9463 329.233 83.9164C331.04 83.3136 332.962 83.1404 334.848 83.4105C338.354 83.9089 341.435 85.8618 343.524 88.909C345.587 92.017 346.436 95.7741 345.911 99.4669C345.386 103.16 343.523 106.531 340.677 108.942C338.401 110.853 335.528 111.909 332.556 111.928Z"
              fill="#222433"/>
        <path d="M331.19 108.519C328.935 108.512 326.761 107.684 325.072 106.19C324.966 106.102 324.877 106.021 324.799 105.942C321.912 103.295 319.051 101.767 314.479 102.905C314.046 103.013 313.59 103.135 313.12 103.261C310.3 104.017 307.104 104.873 305.229 103.724C304.873 103.502 304.567 103.208 304.332 102.86C304.098 102.513 303.939 102.12 303.866 101.706C303.349 99.2671 307.153 97.2303 311.392 95.2942C303.438 95.1223 297.683 94.4736 297.526 91.3031C297.495 90.8569 297.558 90.409 297.713 89.9894C297.869 89.5698 298.112 89.1881 298.426 88.87C299.444 87.8194 301.332 87.156 304.396 86.8275C299.947 86.1827 297.72 85.7807 297.909 83.0032C297.951 82.3925 298.237 81.5195 299.363 80.823C304.113 77.8845 320.9 80.4478 326.813 82.9046C326.813 82.9046 328.524 83.5613 334.496 85.5248C337.477 86.5056 339.649 88.3301 340.954 90.9478C342.198 93.4457 342.35 96.0784 342.259 97.8474C342.041 102.013 339.215 105.956 335.228 107.659C333.954 108.216 332.58 108.509 331.19 108.519ZM317.372 101.075C321.046 101.075 323.59 102.863 325.794 104.887C325.805 104.896 325.815 104.906 325.825 104.916C325.884 104.975 325.945 105.031 326.01 105.084C328.448 107.184 331.597 107.634 334.66 106.326C338.15 104.835 340.622 101.397 340.812 97.772C340.944 95.2163 340.549 89.0428 334.044 86.9022C328.018 84.9203 326.344 84.2769 326.275 84.2506C320.088 81.6805 304.069 79.6174 300.128 82.0563C299.398 82.5075 299.367 82.9551 299.357 83.1021C299.262 84.5073 300.123 84.7456 305.005 85.4501C306.875 85.7203 309.202 86.0563 312.065 86.6102C312.243 86.6447 312.402 86.7447 312.51 86.8905C312.618 87.0363 312.667 87.2173 312.648 87.3978C312.629 87.5783 312.543 87.7451 312.407 87.8653C312.271 87.9855 312.095 88.0504 311.914 88.0471C307.412 87.9661 301.224 88.0676 299.469 89.8786C299.293 90.0543 299.158 90.2664 299.072 90.5C298.987 90.7337 298.954 90.9831 298.976 91.2309C299.004 91.7901 299.69 92.8147 303.976 93.3911C307.158 93.8191 311.327 93.8592 314.677 93.8914C314.842 93.8933 315.002 93.9515 315.129 94.0563C315.257 94.1611 315.344 94.3063 315.378 94.4679C315.412 94.6295 315.39 94.7977 315.315 94.9449C315.24 95.0921 315.117 95.2093 314.967 95.2772C314.602 95.4418 314.226 95.6098 313.844 95.7807C310.512 97.2685 304.936 99.7587 305.285 101.405C305.317 101.625 305.397 101.836 305.518 102.022C305.639 102.209 305.798 102.367 305.986 102.486C307.329 103.31 310.332 102.506 312.744 101.859C313.222 101.731 313.687 101.607 314.127 101.497C315.187 101.224 316.277 101.082 317.372 101.075Z"
              fill="#222433"/>
        <path d="M315.259 143.395C315.117 143.395 314.979 143.354 314.86 143.275C314.742 143.197 314.649 143.086 314.593 142.956C314.537 142.825 314.521 142.681 314.546 142.542C314.571 142.402 314.636 142.273 314.734 142.17L319.37 137.302C319.435 137.232 319.514 137.175 319.601 137.135C319.689 137.096 319.783 137.074 319.879 137.071C319.975 137.068 320.071 137.084 320.16 137.118C320.25 137.152 320.332 137.204 320.402 137.27C320.471 137.337 320.527 137.416 320.566 137.504C320.604 137.592 320.625 137.687 320.627 137.783C320.628 137.879 320.611 137.974 320.575 138.063C320.54 138.153 320.487 138.234 320.42 138.303L315.784 143.17C315.717 143.241 315.635 143.298 315.545 143.337C315.455 143.375 315.357 143.395 315.259 143.395Z"
              fill="#222433"/>
        <path d="M365.395 35.5699C364.877 35.5698 364.359 35.5241 363.849 35.4333C363.755 35.4166 363.665 35.3816 363.585 35.3303C363.505 35.279 363.436 35.2123 363.381 35.1342C363.327 35.0561 363.288 34.9681 363.268 34.8751C363.247 34.7821 363.245 34.686 363.262 34.5922C363.279 34.4985 363.314 34.4089 363.365 34.3287C363.416 34.2485 363.483 34.1792 363.561 34.1247C363.639 34.0703 363.727 34.0317 363.82 34.0113C363.913 33.9908 364.009 33.9889 364.103 34.0056C365.581 34.2713 367.105 34.0756 368.468 33.445C369.83 32.8144 370.966 31.7796 371.72 30.4811C372.474 29.1826 372.81 27.6834 372.682 26.1873C372.555 24.6912 371.969 23.2707 371.006 22.1188C370.043 20.9669 368.748 20.1394 367.299 19.7489C365.849 19.3584 364.314 19.4237 362.902 19.936C361.491 20.4483 360.271 21.3827 359.409 22.6123C358.548 23.8419 358.085 25.307 358.085 26.8086C358.085 27.0009 358.009 27.1853 357.873 27.3213C357.737 27.4573 357.552 27.5337 357.36 27.5337C357.168 27.5337 356.983 27.4573 356.847 27.3213C356.711 27.1853 356.635 27.0009 356.635 26.8086C356.635 25.0758 357.149 23.3819 358.111 21.9411C359.074 20.5003 360.442 19.3773 362.043 18.7142C363.644 18.0511 365.406 17.8776 367.105 18.2157C368.805 18.5537 370.366 19.3881 371.591 20.6134C372.817 21.8387 373.651 23.3998 373.989 25.0993C374.327 26.7989 374.154 28.5605 373.491 30.1614C372.827 31.7623 371.704 33.1306 370.264 34.0933C368.823 35.056 367.129 35.5699 365.396 35.5699H365.395Z"
              fill="#222433"/>
        <path d="M366.568 29.3028C366.484 29.3028 366.4 29.2882 366.322 29.2595L361.171 27.4009C361.033 27.3509 360.913 27.2599 360.827 27.14C360.742 27.0201 360.695 26.877 360.692 26.7297C360.69 26.5824 360.733 26.438 360.815 26.3156C360.897 26.1932 361.014 26.0987 361.151 26.0446L368.155 23.2796C368.244 23.2426 368.34 23.2237 368.436 23.2241C368.532 23.2244 368.628 23.2439 368.716 23.2815C368.805 23.319 368.886 23.3739 368.953 23.4429C369.02 23.5119 369.073 23.5936 369.108 23.6832C369.144 23.7729 369.161 23.8686 369.159 23.965C369.156 24.0613 369.135 24.1563 369.096 24.2443C369.057 24.3323 369 24.4116 368.93 24.4776C368.86 24.5435 368.777 24.5949 368.687 24.6285L363.468 26.6887L366.813 27.8957C366.973 27.9536 367.108 28.0663 367.194 28.2139C367.28 28.3614 367.311 28.5345 367.281 28.7026C367.252 28.8707 367.164 29.0231 367.033 29.1328C366.903 29.2426 366.738 29.3028 366.567 29.3028H366.568Z"
              fill="#222433"/>
        <path d="M103.409 198.508C103.287 198.507 103.167 198.476 103.06 198.417C102.953 198.358 102.862 198.272 102.797 198.169C102.732 198.065 102.694 197.946 102.687 197.824C102.68 197.702 102.704 197.58 102.757 197.47L134.722 130.633C135.268 129.256 135.603 127.805 135.715 126.328C136.003 123.421 135.715 120.486 134.868 117.69C134.021 114.895 132.631 112.293 130.778 110.035C128.926 107.776 126.646 105.905 124.07 104.528C121.493 103.151 118.671 102.295 115.764 102.009C115.669 102 115.576 101.973 115.492 101.928C115.407 101.884 115.332 101.823 115.271 101.749C115.211 101.675 115.165 101.59 115.137 101.499C115.109 101.407 115.1 101.311 115.109 101.216C115.118 101.121 115.146 101.029 115.192 100.944C115.237 100.86 115.298 100.786 115.372 100.725C115.446 100.665 115.532 100.62 115.623 100.592C115.715 100.565 115.811 100.556 115.906 100.566C119.002 100.871 122.007 101.782 124.75 103.248C127.494 104.714 129.921 106.706 131.895 109.11C133.868 111.514 135.349 114.283 136.252 117.26C137.156 120.236 137.464 123.361 137.159 126.457C137.038 128.101 136.659 129.716 136.037 131.242L104.063 198.095C104.004 198.219 103.912 198.323 103.796 198.396C103.68 198.469 103.546 198.508 103.409 198.508Z"
              fill="#222433"/>
    </svg>

<?php $settings['thank_you_text'] = ob_get_clean();

$settings['hide_registation_form'] = false;
$settings['hide_buy_license'] = false;

if ( count($xstore_branding_settings) && isset($xstore_branding_settings['control_panel']) ) {
    if ( $xstore_branding_settings['control_panel']['welcome_text'] ) {
        $settings['welcome_text'] = $xstore_branding_settings['control_panel']['welcome_text'];
    }
	
	if ( $xstore_branding_settings['control_panel']['thank_you_text'] ) {
		$settings['thank_you_text'] = $xstore_branding_settings['control_panel']['thank_you_text'];
	}

	if ( isset($xstore_branding_settings['control_panel']['hide_registration_form']) ){
		$settings['hide_registation_form'] = $xstore_branding_settings['control_panel']['hide_registration_form'];
	}

	if ( isset($xstore_branding_settings['control_panel']['hide_buy_license']) ){
		$settings['hide_buy_license'] = $xstore_branding_settings['control_panel']['hide_buy_license'];
	}
}

?>

<div class="et-col-7 etheme-registration">
    <div class="etheme-welcome-message">
        <?php
            echo '<h2 class="etheme-page-title">'. $settings['welcome_text'].'</h2>';
            echo '<div>' . $settings['thank_you_text'] . '</div>';
        ?>

    </div>
	
	<?php if ( ! defined( 'ET_CORE_VERSION' ) && etheme_is_activated() && ! class_exists( 'ETC\App\Controllers\Admin\Import' ) ): ?>

    <p class="et-message et-error flex align-items-center justify-content-between">
		<?php esc_html_e( 'The following required plugin is currently inactive: ', 'xstore' ); ?>
		<?php echo 'XStore Core'; ?>

        <a href="<?php echo admin_url( 'admin.php?page=et-panel-plugins' ); ?>" class="et_core-plugin et-button et-button-green no-transform"
          data-slug="et-core-plugin"><?php echo esc_html__( 'Activate', 'xstore' ); ?>
            <span class="et-loader">
                <svg class="loader-circular" viewBox="25 25 50 50"><circle class="loader-path" cx="50" cy="50"
                                                                           r="12" fill="none" stroke-width="2"
                                                                           stroke-miterlimit="10"></circle></svg>
            </span>
        </a>
        <span class="hidden et_plugin-nonce"
              data-plugin-nonce="<?php echo wp_create_nonce( 'envato_setup_nonce' ); ?>"></span>
		<?php endif; ?>
		<?php if ( ! $result ) : ?>
<p class="et-message et-error"><?php esc_html_e( 'Your system does not meet the server requirements. For more efficient result, we strongly recommend to contact your host provider and check the necessary settings.', 'xstore' ); ?>
    <p>
		<?php endif; ?>
    
    <?php if ( !isset($settings['hide_registation_form']) || !$settings['hide_registation_form'] ) : ?>

        <h3><?php esc_html_e( 'Theme Registration', 'xstore' ) ?></h3>
        <?php $version = new ETheme_Version_Check(); ?>
        <?php $version->activation_page(); ?>
        
        <?php if ( ! etheme_is_activated() ) : ?>
            <h4 class="text-uppercase"><?php esc_html_e( 'Where can I find my purchase code?', 'xstore' ); ?></h4>
    
            <ul>
                <li>1. <?php esc_html_e( 'Please enter your Envato account and find ', 'xstore' ); ?> <a
                            href="https://themeforest.net/downloads"><?php esc_html_e( 'Downloads tab', 'xstore' ); ?></a>
                </li>
                <li>2. <?php esc_html_e( 'Find XStore theme in the list and click on the opposite', 'xstore' ); ?>
                    <span><?php echo esc_html__( 'Download', 'xstore' ); ?></span> <?php esc_html_e( 'button', 'xstore' ); ?>
                </li>
                <li>3. <?php esc_html_e( 'Select', 'xstore' ); ?>
                    <span><?php echo esc_html__( 'License Certificate & Purchase code', 'xstore' ); ?></span> <?php esc_html_e( 'for download', 'xstore' ); ?>
                </li>
                <li>4. <?php esc_html_e( 'Copy the', 'xstore' ); ?>
                    <span><?php esc_html_e( 'Item Purchase Code', 'xstore' ); ?> </span><?php esc_html_e( 'from the downloaded document', 'xstore' ); ?>
                </li>
            </ul>
            <br/>
        <?php endif; ?>
        <br/>
    <?php endif;
    
    if ( !$settings['hide_buy_license'] ) : ?>
        <h3><?php echo esc_html__( 'Buy License', 'xstore' ); ?></h3>
        <p><?php echo sprintf( esc_html__( 'If you don\'t have a license or need another one for a new website, click on a Buy button. Interested in multiple licenses? Contact us via %1scontact form%2s for more details about discounts for you.', 'xstore' ), '<a href="http://8theme.com/contact-us/" target="_blank">', '</a>' ); ?></p>
        <?php $ntb_class = ( ! etheme_is_activated() ) ? 'et-button-grey' : 'et-button-green'; ?>
        <a
                href="https://themeforest.net/cart/configure_before_adding/15780546&size=source&support=bundle_12month&utm_source=8theme%20Shop&utm_medium=shop&utm_campaign=demo"
                class="et-button <?php echo esc_attr( $ntb_class ); ?> last-button no-loader"><?php esc_html_e( 'Purchase now', 'xstore' ); ?>
        </a>
    <?php endif; ?>
</div>