<?php
/**
 * Frontend class
 *
 * @author YITH
 * @package YITH_Store_Locator_Frontend
 * @version 1.0.0
 */

defined( 'YITH_SL' ) || exit; // Exit if accessed directly

if ( ! class_exists( 'Shortcode_YITH_Store_Locator' ) ) {
    /**
     * Shortcode_YITH_Store_Locator
     *
     * @since 1.0.0
     */
    class Shortcode_YITH_Store_Locator extends Abstract_YITH_Store_Locator_Shortcode {

        public static $name = 'yith_store_locator';

        public $atts    =   array(
            'show_map'                                      =>  '',
            'show_filters'                                  =>  '',
            'show_radius_filter'                            =>  '',
            'show_results'                                  =>  '',
            'show_stores_by_default'                        =>  '',
            'results_title'                                 =>  '',
            'map_longitude'                                 =>  '',
            'map_latitude'                                  =>  '',
            'map_type'                                      =>  '',
            'map_zoom'                                      =>  '',
            'map_user_icon'                                 =>  '',
            'map_style'                                     =>  '',
            'map_scroll_type'                               =>  '',
            'show_circle'                                   =>  '',
            'circle_border_color'                           =>  '',
            'circle_border_weight'                          =>  '',
            'circle_background_color'                       =>  '',
            'pin_modal_trigger_event'                       =>  '',
            'enable_autogeolocation'                        =>  '',
            'geolocation_style'                             =>  '',
            'geolocation_text'                              =>  '',
            'enable_instant_search'                         =>  '',
            'show_search_bar'                               =>  '',
            'title_search_bar'                              =>  '',
            'title_search_form'                             =>  '',
            'search_bar_icon'                               =>  '',
            'placeholder_search_form'                       =>  '',
            'search_button_text'                            =>  '',
            'enable_show_all_stores'                        =>  '',
            'show_all_stores_text'                          =>  '',
            'show_filter_radius'                            =>  '',
            'filter_radius_distance_unit'                   =>  '',
            'show_filters_with_results'                     =>  '',
            'filters_display_mode'                          =>  '',
            'search_bar_filters_position'                   =>  '',
            'results_columns'                               =>  '',
            'full_width_layout'                             =>  '',
            'left_padding_full_width_layout'                =>  '',
            'right_padding_full_width_layout'               =>  '',
            'background_color_search_form'                  =>  '',
            'color_placeholder_search_form'                 =>  '',
            'background_color_search_button'                =>  '',
            'hover_background_color_search_button'          =>  '',
            'color_search_button'                           =>  '',
            'hover_color_search_button'                     =>  '',
            'background_color_geolocation_button'           =>  '',
            'hover_background_color_geolocation_button'     =>  '',
            'color_geolocation_button'                      =>  '',
            'hover_color_geolocation_button'                =>  '',
            'icon_geolocation_button'                       =>  '',
            'background_color_view_all_stores_button'       =>  '',
            'hover_background_color_view_all_stores_button' =>  '',
            'color_view_all_stores_button'                  =>  '',
            'hover_color_view_all_stores_button'            =>  '',
            'icon_view_all_stores_button'                   =>  '',
            'view_all_color'                                =>  '',
            'hover_view_all_color'                          =>  '',
            'color_label_featured_store'                    =>  '',
            'background_color_label_featured_store'         =>  '',
            'background_wrapper_featured_store'             =>  '',
            'background_color_get_direction_button'         =>  '',
            'hover_background_color_get_direction_button'   =>  '',
            'color_get_direction_button'                    =>  '',
            'hover_color_get_direction_button'              =>  '',
            'color_link_get_direction_button'               =>  '',
            'hover_color_link_get_direction_button'         =>  '',
            'background_color_contact_store_button'         =>  '',
            'hover_background_color_contact_store_button'   =>  '',
            'color_contact_store_button'                    =>  '',
            'hover_color_contact_store_button'              =>  '',
            'color_contact_store_link'                      =>  '',
            'hover_color_contact_store_link'                =>  '',
            'background_color_view_website_button'          =>  '',
            'hover_background_color_view_website_button'    =>  '',
            'color_view_website_button'                     =>  '',
            'hover_color_view_website_button'               =>  '',
            'color_view_website_link'                       =>  '',
            'hover_color_view_website_link'                 =>  '',
            'pin_modal_width'                               =>  '',
            'background_color_pin_modal'                    =>  '',
            'color_pin_modal'                               =>  '',
            'pin_border_radius'                             =>  '',
            'map_width'                                     =>  '',
            'map_height'                                    =>  '',
            'map_position'                                  =>  '',
            'background_color_scrollbar'                    =>  '',
            'color_scrollbar'                               =>  '',
            'width_scrollbar'                               =>  '',
            'hover_color_results'                           =>  '',
            'color_shades'                                  =>  '',
            'show_store_image'                              =>  '',
            'store_image_position'                          =>  '',
        );

        public function __construct()
        {
            parent::__construct();
        }


        public function get_default_value( $attr ){

            $value = '';
            switch ( $attr ){
                case 'show_map':
                    $value = yith_sl_get_option('enable-map', 'yes' );
                    break;

                case 'show_filters':
                    $value = yith_sl_get_option( 'enable-filters', 'yes' );
                    break;

                case 'show_radius_filter':
                    $value = yith_sl_get_option('enable-filter-radius', 'yes' );
                    break;

                case 'show_results':
                    $value = yith_sl_get_option('enable-stores-list', 'yes' );
                    break;

                case 'show_stores_by_default':
                    $value = yith_sl_get_option('stores-list-by-default', 'no' );
                    break;

                case 'results_title':
                    $value = yith_sl_get_option( "results-title", esc_html__( "Results", "yith-store-locator" ) );;
                    break;

                case 'map_longitude':
                    $value = yith_sl_get_option('map-default-position', array( 'longitude' => '15.142760' ) )['longitude'];
                    break;

                case 'map_latitude':
                    $value = yith_sl_get_option('map-default-position', array( 'latitude' => '37.586310' ) )['latitude'];
                    break;

                case 'map_type':
                    $value = yith_sl_get_option('map-default-type', 'roadmap' );
                    break;

                case 'map_zoom':
                    $value = yith_sl_get_option('map-default-zoom', 10 );
                    break;

                case 'map_user_icon':
                    $value = yith_sl_get_option( 'map-icon-user-position', YITH_SL_ASSETS_URL .'images/store-locator/user-position.svg' );
                    break;

                case 'map_style':
                    $value = json_decode( yith_sl_get_option( 'map-style', '' ) );
                    break;

                case 'map_scroll_type':
                    $value = yith_sl_get_option( 'map-scroll-type', 'cooperative' );
                    break;

                case 'show_circle':
                    $value = yith_sl_get_option( 'enable-circle', 'yes' );
                    break;

                case 'circle_border_color':
                    $value = yith_sl_get_option('circle-colors', array( 'border' => '#18BCA9' ) )['border'];
                    break;

                case 'circle_border_weight':
                    $value = yith_sl_get_option( 'circle-border-weigth', '2' );
                    break;

                case 'circle_background_color':
                    $value = yith_sl_get_option('circle-colors', array( 'background' => '#18BCA9' ) )['background'];
                    break;

                case 'pin_modal_trigger_event':
                    $value = yith_sl_get_option( 'pin-modal-trigger-event', 'mouseover' );
                    break;

                case 'enable_autogeolocation':
                    $value = yith_sl_get_option('enable-autogeolocation', 'no' );
                    break;

                case 'geolocation_style':
                    $value = yith_sl_get_option( 'geolocation-style','button' );
                    break;

                case 'geolocation_text':
                    $value = yith_sl_get_option( 'geolocation-text', esc_html_x( 'Use my position', 'Default text for the geolocalation button inside store locator', 'yith-store-locator' ) );
                    break;

                case 'enable_instant_search':
                    $value = yith_sl_get_option( 'enable-instant-search', 'yes' );
                    break;

                case 'show_search_bar':
                    $value = yith_sl_get_option( 'enable-search-bar', 'yes' );
                    break;

                case 'title_search_bar':
                    $value = yith_sl_get_option( 'title-search-bar', esc_html_x( 'Find our stores', 'Default text to show as title of Search Bar in store locator', 'yith-store-locator' ) );
                    break;

                case 'search_button_text':
                    $value = yith_sl_get_option( 'text-search-button','yes' );
                    break;

                case 'enable_show_all_stores':
                    $value = yith_sl_get_option( 'enable-view-all-stores','yes' );
                    break;

                case 'show_all_stores_text' :
                    $value = yith_sl_get_option( 'view-all-stores-text', esc_html_x( 'View all stores', 'Text for the button "Show all stores" inside the store locator', 'yith-store-locator' ) );
                    break;

                case 'filter_radius_distance_unit':
                    $value = yith_sl_get_option('filter-radius-distance-unit', 'km' );
                    break;

                case 'show_filters_with_results':
                    $value = yith_sl_get_option( 'show-filters-with-results', 'yes' );
                    break;

                case 'search_bar_filters_position':
                    $value = yith_sl_get_option( 'search-bar-filters-position', 'beside-map' );
                    break;

                case 'results_columns':
                    $value = yith_sl_get_option( 'results-columns', 'one' );
                    break;

                case 'full_width_layout':
                    $value = yith_sl_get_option('full-width-layout', 'no' );
                    break;

                case 'left_padding_full_width_layout':
                    $value = yith_sl_get_option('side-padding-full-width', array( 'left'  =>  0 ) )['left'];
                    break;

                case 'right_padding_full_width_layout':
                    $value = yith_sl_get_option('side-padding-full-width', array( 'right'  =>  0 ) )['right'];
                    break;

                case 'placeholder-search-form':
                    $value = yith_sl_get_option( 'placeholder-search-form', esc_html_x( 'Enter address / city', 'Placeholder to show for the search address input inside the store locator', 'yith-store-locator') );
                    break;

                case 'background_color_search_form':
                    $value = yith_sl_get_option( 'search-form-colors', array( 'background' => '#ffffff' ) )['background'];
                    break;

                case 'color_placeholder_search_form':
                    $value = yith_sl_get_option( 'search-form-colors', array( 'color' => '#9D9D9D' ) )['color'];
                    break;

                case 'background_color_search_button':
                    $value = yith_sl_get_option( 'background-color-search-button', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_background_color_search_button':
                    $value = yith_sl_get_option( 'background-color-search-button', array( 'hover' => '#008A81' ) )['hover'];
                    break;

                case 'color_search_button':
                    $value = yith_sl_get_option( 'color-search-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_color_search_button':
                    $value = yith_sl_get_option( 'color-search-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'background_color_geolocation_button':
                    $value = yith_sl_get_option( 'background-color-geolocation-button', array( 'normal' => '#3A3A3A' ) )['normal'];
                    break;

                case 'hover_background_color_geolocation_button':
                    $value = yith_sl_get_option( 'background-color-geolocation-button', array( 'hover' => '#0D0D0D' ) )['hover'];
                    break;

                case 'color_geolocation_button':
                    $value = yith_sl_get_option( 'color-geolocation-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_color_geolocation_button':
                    $value = yith_sl_get_option( 'color-geolocation-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'icon_geolocation_button':
                    $value = yith_sl_get_option( 'icon-geolocation', YITH_SL_ASSETS_URL . 'images/store-locator/geolocation.svg' );
                    break;

                case 'background_color_view_all_stores_button':
                    $value = yith_sl_get_option( 'background-color-view-all-stores-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_background_color_view_all_stores_button':
                    $value = yith_sl_get_option( 'background-color-view-all-stores-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'color_view_all_stores_button':
                    $value = yith_sl_get_option( 'color-view-all-stores-button', array( 'normal' => '#3A3A3A' ) )['normal'];
                    break;

                case 'hover_color_view_all_stores_button':
                    $value = yith_sl_get_option( 'color-view-all-stores-button', array( 'hover' => '#3A3A3A' ) )['hover'];
                    break;

                case 'icon_view_all_stores_button':
                    $value = yith_sl_get_option( 'all-stores-icon', YITH_SL_ASSETS_URL . 'images/store-locator/all-stores.svg' );
                    break;

                case 'view_all_color':
                    $value = yith_sl_get_option( 'view-all-color', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_view_all_color':
                    $value = yith_sl_get_option( 'view-all-color', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'color_label_featured_store':
                    $value = yith_sl_get_option( 'stores-list-featured-colors', array( 'label-color' => '#ffffff' ) )['label-color'];
                    break;

                case 'background_color_label_featured_store':
                    $value = yith_sl_get_option( 'stores-list-featured-colors', array( 'label-background' => '#18BCA9' ) )['label-background'];
                    break;

                case 'background_wrapper_featured_store':
                    $value = yith_sl_get_option( 'stores-list-featured-colors', array( 'wrapper-background' => '#F4F4F4' ) )['wrapper-background'];
                    break;

                case 'background_color_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-get-direction-button', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_background_color_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-get-direction-button', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'color_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-color-get-direction-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_color_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-color-get-direction-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'color_link_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-color-get-direction-link', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_color_link_get_direction_button':
                    $value = yith_sl_get_option( 'stores-list-color-get-direction-link', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'background_color_contact_store_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-contact-store-button', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_background_color_contact_store_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-contact-store-button', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'color_contact_store_button':
                    $value = yith_sl_get_option( 'stores-list-color-contact-store-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_color_contact_store_button':
                    $value = yith_sl_get_option( 'stores-list-color-contact-store-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'color_contact_store_link':
                    $value = yith_sl_get_option( 'stores-list-color-contact-store-link', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_color_contact_store_link':
                    $value = yith_sl_get_option( 'stores-list-color-contact-store-link', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'background_color_view_website_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-visit-website-button', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_background_color_view_website_button':
                    $value = yith_sl_get_option( 'stores-list-background-color-visit-website-button', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'color_view_website_button':
                    $value = yith_sl_get_option( 'stores-list-color-visit-website-button', array( 'normal' => '#ffffff' ) )['normal'];
                    break;

                case 'hover_color_view_website_button':
                    $value = yith_sl_get_option( 'stores-list-color-visit-website-button', array( 'hover' => '#ffffff' ) )['hover'];
                    break;

                case 'color_view_website_link':
                    $value = yith_sl_get_option( 'stores-list-color-visit-website-link', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'hover_color_view_website_link':
                    $value = yith_sl_get_option( 'stores-list-color-visit-website-link', array( 'hover' => '#008a81' ) )['hover'];
                    break;

                case 'pin_modal_width':
                    $value = yith_sl_get_option( 'pin-modal-width', '400' );
                    break;

                case 'background_color_pin_modal':
                    $value = yith_sl_get_option( 'pin-modal-colors', array( 'background' => '#ffffff' ) )['background'];
                    break;

                case 'color_pin_modal':
                    $value = yith_sl_get_option( 'pin-modal-colors', array( 'color' => '#000000' ) )['color'];
                    break;

                case 'pin_border_radius':
                    $value = yith_sl_get_option( 'pin-border-radius','0' );
                    break;

                case 'map_width':
                    $value = yith_sl_get_option( 'map-width','65' );
                    break;

                case 'map_height':
                    $value = yith_sl_get_option( 'map-height','500' );
                    break;

                case 'map_position':
                    $value = yith_sl_get_option( 'map-position','map-right' );
                    break;

                case 'background_color_scrollbar':
                    $value = yith_sl_get_option( 'scrollbar-colors', array( 'main' => '#d0d0d0' ) )['main'];
                    break;

                case 'color_scrollbar':
                    $value = yith_sl_get_option( 'scrollbar-colors', array( 'thumb' => '#18BCA9' ) )['thumb'];
                    break;

                case 'width_scrollbar':
                    $value = yith_sl_get_option( 'scrollbar-width','5' );
                    break;

                case 'hover_color_results':
                    $value = yith_sl_get_option( 'result-hover-color', '#E7F5F5' );
                    break;

                case 'color_shades':
                    $value = defined( 'YITH_PROTEO_VERSION' ) ? get_theme_mod( 'yith_proteo_main_color_shade', '#18BCA9' ) :  yith_sl_get_option( 'color-shades', array( 'normal' => '#18BCA9' ) )['normal'];
                    break;

                case 'filters_display_mode':
                    $value = yith_sl_get_option( 'filters-display-mode', 'opened' );
                    break;

                case 'show_filter_radius':
                    $value = yith_sl_get_option( 'enable-filter-radius', 'yes' );
                    break;

                case 'search_bar_icon':
                    $value = yith_sl_get_option( 'icon-search-bar', YITH_SL_ASSETS_URL . 'images/store-locator/search.svg' );
                    break;

                case 'show_store_image':
                    $value = yith_sl_get_option('stores-list-show-store-image', 'yes' );
                    break;

                case 'store_image_position':
                    $value = yith_sl_get_option('stores-list-image-position', 'left' );
                    break;

                default:
                    break;
            }

            return $value;

        }


        public function before_output(){
            wp_enqueue_script( 'yith-store-locator' );
            wp_enqueue_script( 'yith-store-locator-filters-dropdown' );
            $options = array(
                'show_map'                              =>  $this->atts['show_map'],
                'show_results'                          =>  $this->atts['show_results'],
                'show_stores_by_default'                =>  $this->atts['show_stores_by_default'],
                'map_longitude'                         =>  $this->atts['map_longitude'],
                'map_latitude'                          =>  $this->atts['map_latitude'],
                'map_type'                              =>  $this->atts['map_type'],
                'map_zoom'                              =>  $this->atts['map_zoom'],
                'map_user_icon'                         =>  $this->atts['map_user_icon'],
                'map_style'                             =>  $this->atts['map_style'],
                'map_scroll_type'                       =>  $this->atts['map_scroll_type'],
                'show_circle'                           =>  $this->atts['show_circle'],
                'circle_border_color'                   =>  $this->atts['circle_border_color'],
                'circle_border_weight'                  =>  $this->atts['circle_border_weight'],
                'circle_background_color'               =>  $this->atts['circle_background_color'],
                'pin_modal_trigger_event'               =>  $this->atts['pin_modal_trigger_event'],
                'ajaxurl'                               =>  admin_url('admin-ajax.php'),
                'alert_geolocalization_not_supported'   =>  esc_html__( 'Geolocalization not supported by your browser', 'yith-store-locator' ),
                'alert_calculate_position_error'        =>  esc_html__( 'It\'s not possible geolocate your position', 'yith-store-locator' ),
                'action_get_results'                    => 'yith_sl_get_results',
                'autogeolocation'                       =>  $this->atts['enable_autogeolocation'],
                'autosearch'                            =>  $this->atts['enable_instant_search'],
                'filter_radius_default_step'            =>  get_option( 'yith_sl_default_radius', '50' ),
                'filter_radius_distance_unit'           =>  $this->atts['filter_radius_distance_unit'],
                'show_filters_with_results'             =>  $this->atts['show_filters_with_results'],
                'search_bar_filters_position'           =>  $this->atts['search_bar_filters_position'],
                'filter_radius_title'                   =>  YITH_Store_Locator_Filters_Taxonomies()->get_filter_radius_title(),
                'results_columns'                       =>  $this->atts['results_columns'],
                'full_width_layout'                     =>  $this->atts['full_width_layout'],
                'left_padding_full_width_layout'        =>  $this->atts['left_padding_full_width_layout'],
                'right_padding_full_width_layout'       =>  $this->atts['right_padding_full_width_layout'],
                'geocode_no_results'                    =>  esc_html__( 'No results found', 'yith-store-locator' ),
                'geocode_failed_to'                     =>  esc_html__( 'Geocoder failed due to:', 'yith-store-locator' )
            );

            $script = 'var yith_sl_store_locator = '. json_encode( $options );

            wp_add_inline_script( 'yith-store-locator',$script );

            $settings_css = require_once ( YITH_SL_PATH . 'assets/css/settings.php' );
            wp_enqueue_style('yith-sl-custom', YITH_SL_ASSETS_URL . 'css/frontend/custom.css', array(), YITH_SL_VERSION );

            wp_add_inline_style( 'yith-sl-custom', $settings_css );

            $search_bar_filters_position        =   $this->atts['search_bar_filters_position'];
            $hook_for_search_bar_and_filters    =   $search_bar_filters_position === 'beside-map' ? 'yith-sl-store-locator-left-content' : 'yith-sl-before-main-sections';
            $hook_for_search_button             =   $search_bar_filters_position === 'beside-map' ? 'yith-sl-after-filters-container' : 'yith-sl-after-filters-list' ;

            add_action( $hook_for_search_bar_and_filters, [ $this, 'show_store_locator_search_box' ] );

            if( $this->atts['show_filters'] === 'yes' || $this->atts['show_radius_filter'] === 'yes' ){
                add_action( $hook_for_search_bar_and_filters, [ $this, 'show_store_locator_filters' ],15 );
                add_action( $hook_for_search_button, [ $this, 'show_store_locator_search_button' ] );
            }else{
                add_action( 'yith-sl-after-search-store-container', [ $this, 'show_store_locator_search_button' ] );
            }
            if( $this->atts['show_results'] === 'yes' ){
                add_action( 'yith-sl-store-locator-left-content', [ $this, 'show_store_locator_results' ], 20 );
            }
            if( $this->atts['show_map'] === 'yes' ){
                add_action( 'yith-sl-store-locator-right-content', [ $this, 'show_store_locator_map' ] );
            }
        }


        public function output(){
            $args = array(
                'show_store_image'              =>  $this->atts['show_store_image'],
                'store_image_position'          =>  $this->atts['store_image_position'],
                'search_bar_filters_position'   =>  $this->atts['search_bar_filters_position'],
                'map_position'                  =>  $this->atts['map_position'],
                'full_width_layout'             =>  $this->atts['full_width_layout']
            );
            ob_start();
            yith_sl_get_template( 'store-locator.php','frontend/shortcodes/', $args );
            return ob_get_clean();
        }



        public function show_store_locator_map(){
            $args = array(
                'height'    =>    $this->atts['map_height']
            );
             yith_sl_get_template( 'map.php','frontend/shortcodes/', $args );
        }


        public function show_store_locator_results(){
            $args = array(
                'results_title'    =>    $this->atts['results_title']
            );
            yith_sl_get_template( 'results.php','frontend/shortcodes/', $args );
        }


        public function show_store_locator_filters(){
            $args = array(
                'filters_display_mode'    =>    $this->atts['filters_display_mode'],
                'show_filter_radius'      =>    $this->atts['show_filter_radius']
            );
            yith_sl_get_template( 'filters.php','frontend/shortcodes/', $args );
        }


        public function show_store_locator_search_button(){
            $args = array(
                'enable_instant_search'     =>  $this->atts['enable_instant_search'],
                'search_button_text'        =>  $this->atts['search_button_text']
            );
            yith_sl_get_template( 'search-button.php','frontend/shortcodes/', $args );
        }

        /**
         * Show store locator search box template
         * @param $atts
         * @param null $content
         */
        public function show_store_locator_search_box(){
            $args = array(
                'search_bar_icon'           =>  $this->atts['search_bar_icon'],
                'show_search_bar'           =>  $this->atts['show_search_bar'],
                'title_search_bar'          =>  $this->atts['title_search_bar'],
                'placeholder_search_form'   =>  $this->atts['placeholder_search_form'],
                'enable_autogeolocation'    =>  $this->atts['enable_autogeolocation'],
                'geolocation_style'         =>  $this->atts['geolocation_style'],
                'geolocation_text'          =>  $this->atts['geolocation_text'],
                'show_all_stores_text'      =>  $this->atts['show_all_stores_text'],
                'enable_show_all_stores'    =>  $this->atts['enable_show_all_stores']
            );
            yith_sl_get_template( 'search.php','frontend/shortcodes/', $args );
        }





    }
}


function shortcode_yith_store_locator(){
    return new Shortcode_YITH_Store_Locator();
}

shortcode_yith_store_locator();