<?php
/**
 * Frontend class
 *
 * @author YITH
 * @package YITH_Store_Locator_Frontend
 * @version 1.0.0
 */

defined( 'YITH_SL' ) || exit; // Exit if accessed directly

if ( ! class_exists( 'YITH_Store_Locator_Frontend' ) ) {
    /**
     * YITH_Store_Locator_Frontend
     *
     * @since 1.0.0
     */
    class YITH_Store_Locator_Frontend {


        /**
         * Single instance of the class
         *
         * @var YITH_Store_Locator_Frontend
         * @since 1.0.0
         */
        protected static $instance;


        /**
         * @var string
         */
        private $_ajax_get_results = 'get_results';


        /**
         * Returns single instance of the class
         *
         * @return YITH_Store_Locator_Frontend
         * @since 1.0.0
         */
        public static function get_instance(){
            if( is_null( self::$instance ) ){
                self::$instance = new self();
            }
            return self::$instance;
        }


        /**
         * Constructor
         *
         * @return void
         * @since 1.0.0
         */
        private function __construct() {

            require_once ( 'assets/class.yith-store-locator-frontend-scripts.php' );
            YITH_Store_Locator_Frontend_Scripts();

            /* Ajax call */
            add_action( 'wp_ajax_yith_sl_' . $this->_ajax_get_results, [ $this,'get_results' ] );
            add_action( 'wp_ajax_nopriv_yith_sl_' . $this->_ajax_get_results, [ $this,'get_results' ] );

            /* Filter body class to add layout */
            add_filter( 'body_class', [ $this,'add_body_class' ] );

            /* Load template for single page layout of a store */
            add_filter('single_template', [ $this,'yith_sl_load_single_template' ], 100 );

            /* Add page loader */
            add_action( 'wp_footer', [ $this, 'add_page_loader' ] );

            /* Filter options */
            add_filter( 'yith_sl_store_locator_options', [ $this, 'filter_options' ],10,2 );

        }


        /**
         * Ajax call used to print results on frontend
         */
        public function get_results(){

            $args = array(
                'filters'       =>  isset( $_POST['filters'] ) ? $_POST['filters'] : '',
                'latitude'      =>  isset( $_POST['latitude'] ) ? $_POST['latitude'] : '',
                'longitude'     =>  isset( $_POST['longitude'] ) ? $_POST['longitude'] : '',
                'radius_step'   =>  isset( $_POST['radius_step'] ) ? absint( $_POST['radius_step'] ) : get_option( 'yith_sl_default_radius', 50 )
            );

            $stores = yith_sl_get_stores( $args );

            $template_args = array(
                'stores'    =>  $stores,
                'filters'   =>  isset( $_POST['filters'] ) ? $_POST['filters'] : '',
            );

            ob_start();

            yith_sl_get_template( 'results.php', 'frontend/shortcodes/store-locator/', $template_args );

            $html_results = ob_get_clean();

            ob_start();

            yith_sl_get_template( 'active-filters.php','frontend/shortcodes/store-locator/',$args );

            $html_filters = ob_get_clean();

            $html = array(
                'active_filters'    =>  $html_filters,
                'results'           =>  $html_results,
                'markers'           =>  $stores,
            );
            wp_send_json($html);

            die();

        }


        /**
         * Load template for single store locator page
         * @param $single
         * @return string
         */
        public function yith_sl_load_single_template( $template ){
            global $post;

            if ( $post->post_type === YITH_Store_Locator_Post_Type::$post_type_name ) {
                $template = yith_sl_get_template( 'main.php', 'frontend/single/', array(), false );
            }

            return $template;

        }


        /**
         * Check if is store locator page
         * @return bool
         */
        public function is_store_page(){
            global $post;
            return $post && $post instanceof WP_Post && $post->post_type == YITH_Store_Locator_Post_Type::$post_type_name;
        }


        /**
         * Check if he page is the one used for search locators
         * @return bool
         */
        public function is_store_locator_page(){
            global $post;
            return $post && $post instanceof WP_Post && has_shortcode( $post->post_content,'yith_store_locator' );
        }


        /**
         * Add custom class to body class
         * @param $classes
         * @return array
         */
        public function add_body_class( $classes ){
            $single_layout                  = yith_sl_get_option('single-layout', 'classic' );
            if( $this->is_store_page() ){
                $classes[] = 'yith-sl-layout-' . $single_layout;
            }
            return $classes;
        }

        /**
         * Add page loader inside the Store Locator page
         */
        public function add_page_loader(){
            if( $this->is_store_locator_page() ){
                yith_sl_get_template( 'loader.php', 'frontend/' );
            }
        }


        /**
         * Filter plugin options
         * @param $value
         * @param $key
         * @return string
         */
        public function filter_options( $value, $key ){
            if( wp_is_mobile() && $key === 'pin-modal-trigger-event' ){
                $value = 'click';
            }
            return $value;
        }

    }
}
