<?php
/**
* Plugin Name: WP WC User Registration
* Plugin URI: https://codeincept.com/
* Description: Wordpress Woocommerce user registration management
* Version: 1.0.7
* Author: CodeIncept
* Author URI: https://codeincept.com/
* Support: http://www.codeincept.com/
* License: GPL-2.0+
* License URI: http://www.gnu.org/licenses/gpl-2.0.txt
* Text Domain: wpwc-registration
* Domain Path: /languages/
**/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
} //!defined('ABSPATH')
if (!defined('WPWC_REG_DIR'))
    define('WPWC_REG_DIR', plugin_dir_path(__FILE__));
if (!defined('WPWC_REG_URL'))
    define('WPWC_REG_URL', plugin_dir_url(__FILE__));
if (!class_exists("WPWC_User_Registration")){
    class WPWC_User_Registration
    {
    	public function __construct(){
    		/**
			 * Check if WooCommerce is installed and active.
			 **/
    		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins')))){
				$this->wpwc_init();
	    	}else{
	    		 add_action('admin_notices',  array($this, 'wpwc_admin_notices'));
	    	}
		}
		public function wpwc_init(){
			/**        
		    * Load language.     
		    */
		    if ( function_exists( 'load_plugin_textdomain' ) ){
				load_plugin_textdomain('wpwc-registration', false, dirname(plugin_basename(__FILE__)) . '/languages/');
			}
				require_once WPWC_REG_DIR.'/includes/class-wpwc-common.php';
			if(is_admin()){
			    require_once WPWC_REG_DIR.'/includes/class-wpwc-custom-fields-settings.php';
    			require_once WPWC_REG_DIR.'/includes/class-wpwc-admin-settings.php';
    		}else{
    			require_once WPWC_REG_DIR.'/includes/class-wpwc-frontend.php';
    		}
		}
	    public function wpwc_admin_notices(){
	    	global $pagenow;
	    	if($pagenow==='plugins.php'){
		    	$class = 'notice notice-error is-dismissible';
	            $message = esc_html_x('Custom Box Product needs Woocommerce to be installed and active.','Plugin requirement notification.', 'wpwc-registration');
	            printf('<div class="%1$s"><p>%2$s</p></div>', $class, $message);
	        }
	    }
	}
	new WPWC_User_Registration();
}