<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
} //!defined('ABSPATH')
if(!class_exists('WPWC_User_Registration_Frontend')){
	class WPWC_User_Registration_Frontend{
		public function __construct(){
			if(get_option('wpwc_enable_user_authentication')=='yes'){
				add_filter('authenticate', array($this,'authenticate_user'),100,2);
				add_filter('woocommerce_registration_auth_new_customer', array($this,'check_status_login'),10,2 );
				add_action('init',array($this,'before_custom_error'));
			}
			// register form
			if(get_option('wpwc_enable_user_role_field')=='yes'){
				add_action('woocommerce_register_form', array($this,'register_fields'));
			}
			add_action('user_register', array($this,'user_register_callback'));
			add_action('woocommerce_register_form_start', array($this,'wpwc_extra_register_fields_start' ));
			add_action('woocommerce_register_form', array($this,'wpwc_extra_register_fields_end' ));
			add_action('woocommerce_edit_account_form', array($this,'edit_register_fields' ) ); // my account
			add_action('woocommerce_save_account_details', array($this,'edit_save_validate_fields'),10,1 );
			add_action('woocommerce_register_form_tag',array($this,'wpwc_add_custom_upload_attr'));
            add_action('woocommerce_edit_account_form_tag',array($this,'wpwc_add_custom_upload_attr'));
			add_action('woocommerce_register_post', array($this,'validate_fields'), 10, 3 );
			add_action('wp_enqueue_scripts', array($this,'enqueue_scripts'));
		}
		public function wpwc_add_custom_upload_attr(){
            echo 'enctype="multipart/form-data"';
		}
		public function authenticate_user($user,$username){
			if(is_object($user) && !is_wp_error($user)){
				$user_data = $user->data;
			    $user_id = $user_data->ID;
			    $user_sts = get_user_meta($user_id,"wpwc_user_auth_status",true);
			    if ($user_sts==="disabled")
			    {
					$value=get_option('wpwc_account_disable_error');
					$value=!empty($value) ? $value : esc_html__('Your account is disablled.','wpwc-registration');
			        return new WP_Error( 'disabled_account',$value);
			    }else{
			       return $user;
			    }
			}
        	return $user;
		}
		public function before_custom_error(){
			if(isset($_COOKIE['wpwc_registration'])){
				setcookie("wpwc_registration", null, time());
				add_action('woocommerce_before_customer_login_form',array($this,'custom_error'));
			}
		}
		public function check_status_login($status, $user_id){
		    $user_sts = get_user_meta($user_id,"wpwc_user_auth_status",true);
		    if ($user_sts==="disabled")
		    {
		    	setcookie("wpwc_registration", $user_id, time()+10);
				$status = false;
			}
			return $status;
		}
		public function custom_error(){
			$error=get_option('wpwc_account_disable_error');
			$error=!empty($error) ? $error : esc_html__('You are registered but your account is disabled.','wpwc-registration');
			?>
			<div class="woocommerce-notices-wrapper">
				<div class="woocommerce-error" role="alert">
					<?php echo '<strong>'.esc_html__('Error:', 'wpwc-registration').'</strong> '.$error;  ?>	
				</div>
			</div>
			<?php
		}
		public function wpwc_extra_register_fields_start(){
			wp_enqueue_script('woocommerce');
			wp_enqueue_script('wc-country-select');
			wp_enqueue_style('wpwc-style');
			$custom=get_option('wpwc_custom_fields_position','start');
		    if($custom=='start'){
    			$fields=get_option('wpwc_custom_registration_fields');
    			if(!empty($fields)){
    				foreach ($fields as $key => $field) {
    					$default=( ! empty( $_POST['wpwc_custom_registration_field_'.$key] ) ) ? esc_attr( wp_unslash( $_POST['wpwc_custom_registration_field_'.$key] ) ) : '';
    					if($field['type'] == 'file'){
    						$status=($field['required']==true) ? '<abbr class="required" title="required">*</abbr>' : '<span class="optional">(optional)</span>';
    						echo '<p class="form-row">';
    						echo '<label for="wpwc_custom_registration_field_'.esc_attr($key).'" class="">'.esc_html($field["label"]).'&nbsp; '.$status.'</label>';
    						echo '<span class="woocommerce-input-wrapper"><input type="file" name="wpwc_custom_registration_field_'.esc_attr($key).'" value=""></span></p>';
    						if(!empty($field['description']))
    						echo '<p class="form-row">'.esc_html($field['description']).'</p>';
    					}elseif($field['type'] == 'texthtml'){
    						echo '<p class="form-row field_'.esc_attr($key).'">'.wp_kses_post($field['description']).'</p>';
    					}else{
    						echo woocommerce_form_field('wpwc_custom_registration_field_'.$key, $field, $default );
    					}
    				}
    			}
		    }
			$default=get_option('wpwc_default_fields_position','start');
		    if($default=='start'){
    			$data=get_option('wpwc_fields_registration_form');
    			if(!empty($data)){
    				foreach ($data as $key => $value) {
    					if(isset($value['enable']) && $value['enable']=='yes'){
    						$default=( ! empty( $_POST[$key] ) ) ? esc_attr( wp_unslash( $_POST[$key] ) ) : '';
    						echo woocommerce_form_field( $key, $value, $default );
    					}
    				}
    			}
		    }
		}
		public function wpwc_extra_register_fields_end(){
		    wp_enqueue_script('woocommerce');
			wp_enqueue_script('wc-country-select');
			wp_enqueue_style('wpwc-style');
		    $custom=get_option('wpwc_custom_fields_position');
		    if($custom=='end'){
	        	$fields=get_option('wpwc_custom_registration_fields');
    			if(!empty($fields)){
    				foreach ($fields as $key => $field) {
    					$default=( ! empty( $_POST['wpwc_custom_registration_field_'.$key] ) ) ? esc_attr( wp_unslash( $_POST['wpwc_custom_registration_field_'.$key] ) ) : '';
    					if($field['type'] == 'file'){
    						$status=($field['required']==true) ? '<abbr class="required" title="required">*</abbr>' : '<span class="optional">(optional)</span>';
    						echo '<p class="form-row">';
    						echo '<label for="wpwc_custom_registration_field_'.esc_attr($key).'" class="">'.esc_html($field["label"]).'&nbsp; '.$status.'</label>';
    						echo '<span class="woocommerce-input-wrapper"><input type="file" name="wpwc_custom_registration_field_'.esc_attr($key).'" value=""></span></p>';
    						if(!empty($field['description']))
    						echo '<p class="form-row">'.esc_html($field['description']).'</p>';
    					}elseif($field['type'] == 'texthtml'){
    						echo '<p class="form-row field_'.esc_attr($key).'">'.wp_kses_post($field['description']).'</p>';
    					}else{
    						echo woocommerce_form_field('wpwc_custom_registration_field_'.$key, $field, $default );
    					}
    				}
    			}
		    }
		    $default=get_option('wpwc_default_fields_position');
		    if($default=='end'){
    		    $data=get_option('wpwc_fields_registration_form');
    			if(!empty($data)){
    				foreach ($data as $key => $value) {
    					if(isset($value['enable']) && $value['enable']=='yes'){
    						$default=( ! empty( $_POST[$key] ) ) ? esc_attr( wp_unslash( $_POST[$key] ) ) : '';
    						echo woocommerce_form_field( $key, $value, $default );
    					}
    				}
    			}
		    }
		}
		public function edit_register_fields(){
			wp_enqueue_script('woocommerce');
			wp_enqueue_script('wc-country-select');
			wp_enqueue_style('wpwc-style');
			$data=get_option('wpwc_fields_registration_form');
			$user_id=get_current_user_id();
			$fields=get_option('wpwc_custom_registration_fields');
			if(!empty($fields)){
				foreach ($fields as $key => $field) {
					$default=( ! empty( $_POST['wpwc_custom_registration_field_'.$key] ) ) ? esc_attr( wp_unslash( $_POST['wpwc_custom_registration_field_'.$key] ) ) : get_user_meta($user_id, 'wpwc_custom_registration_field_'.$key,true);
					if($field['type'] == 'file'){
						$status=($field['required']==true) ? '<abbr class="required" title="required">*</abbr>' : '<span class="optional">(optional)</span>';
						echo '<p class="form-row">';
						echo '<label for="wpwc_custom_registration_field_'.esc_attr($key).'" class="">'.esc_html($field["label"]).'&nbsp; '.$status.'</label>';
						echo '<span class="woocommerce-input-wrapper"><input type="file" name="wpwc_custom_registration_field_'.esc_attr($key).'" value=""></span></p>';
						if(!empty($field['description']))
						echo '<p class="form-row">'.esc_html($field['description']).'</p>';
					}elseif($field['type'] == 'texthtml'){
						echo '<p class="form-row field_'.esc_attr($key).'">'.wp_kses_post($field['description']).'</p>';
					}else{
						echo woocommerce_form_field('wpwc_custom_registration_field_'.$key, $field, $default );
					}
				}
			}
			if(!empty($data)){
				foreach ($data as $key => $value) {
					if(isset($value['enable']) && $value['enable']=='yes' && !($key=='first_name' || $key=='last_name')){
						$default=get_user_meta($user_id, $key,true);
						echo woocommerce_form_field( $key, $value, $default );
					}
				}
			}
		}
		public function edit_save_validate_fields($user_id){
			$data=get_option('wpwc_fields_registration_form');
			if(!empty($data)){
				foreach ($data as $key => $value) {
					if(isset($value['enable']) && $value['enable']=='yes' && isset($_POST[$key]) && !($key=='first_name' || $key=='last_name')){
						update_user_meta( $user_id, $key, sanitize_text_field($_POST[$key]));
					}
				}
			}
			$fields=get_option('wpwc_custom_registration_fields');
			if(!function_exists('wp_handle_upload')){
                require_once(ABSPATH.'wp-admin/includes/file.php');
                require_once(ABSPATH.'wp-admin/includes/image.php');
                require_once(ABSPATH.'wp-admin/includes/media.php');
            }
			if(!empty($fields)){
				foreach ($fields as $key => $field) {
					if($field['type'] == 'file' && !empty($_FILES['wpwc_custom_registration_field_'.$key])){
						$attach_id=media_handle_upload('wpwc_custom_registration_field_'.esc_attr($key), $user_id);
						update_user_meta( $user_id, 'wpwc_custom_registration_field_'.$key, $attach_id);
					}
					if(isset($_POST['wpwc_custom_registration_field_'.$key]) ){
						update_user_meta( $user_id, 'wpwc_custom_registration_field_'.$key, sanitize_text_field($_POST['wpwc_custom_registration_field_'.$key]));
					}
				}
			}
		}
		public function register_fields(){
			global $wp_roles;
            $roles = $wp_roles->get_names();
			$selected=get_option('wpwc_user_role_dropdown_options');
			$label=get_option('wpwc_user_role_field_label');
			?>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="rbp_user_role"><?php echo !empty($label) ? $label : esc_html__( 'Select Role', 'wpwc-registration' ); ?>&nbsp;
				<?php if(get_option('wpwc_user_role_field_required')=='yes') { ?><span class="required">*</span></label><?php } ?>
				<select name="wpwc_user_role" id="wpwc_user_role" class="woocommerce-Input woocommerce-Input--text input-text">
					<option value=""><?php esc_html_e('Select Role','wpwc-registration'); ?></option>
					<?php if(!empty($roles)): 
						$default=( ! empty( $_POST['wpwc_user_role'] ) ) ? esc_attr( wp_unslash( $_POST['wpwc_user_role'] ) ) : '';
						foreach ($selected as $key => $value) {
							if(isset($roles[$value])){
								$selected=($default==$value) ? 'selected' : '';
								echo '<option value="'.esc_attr($value).'" '.$selected.'>'.esc_attr($roles[$value]).'</option>';
							}
						}
					 endif; ?>
				</select>
			</p>
			<?php
		}
		public function validate_fields($username, $email, $validation_errors){
			if(isset($_POST['wpwc_user_role']) && empty($_POST['wpwc_user_role']) && get_option('wpwc_user_role_field_required')=='yes'){
				$validation_errors->add( 'wpwc_user_role', esc_html__('User Role is required!', 'wpwc-registration' ) );
			}
			$data=get_option('wpwc_fields_registration_form');
			if(!empty($data)){
				foreach ($data as $key => $value) {
					if(isset($value['enable']) && $value['enable']=='yes' && isset($value['required']) && $value['required']=='yes' && empty($_POST[$key])){
						$validation_errors->add( $key, sprintf(esc_html__('%s is required!', 'wpwc-registration' ),$value['label']) );
					}
				}
			}
			$fields=get_option('wpwc_custom_registration_fields');
			if(!empty($fields)){
				foreach ($fields as $key => $field) {
					if(isset($_POST['wpwc_custom_registration_field_'.$key]) && (isset($field['required']) && $field['required']==true && empty($_POST['wpwc_custom_registration_field_'.$key]))){
						$validation_errors->add('wpwc_custom_registration_field_'.$key, sprintf(esc_html__('%s is required!', 'wpwc-registration' ),$field['label']) );
					}
					if ( $field['type'] != 'file' && !isset($_POST['wpwc_custom_registration_field_'.$key]) && (isset($field['required']) && $field['required']==true && empty($_POST['wpwc_custom_registration_field_'.$key])) ) {
						$validation_errors->add('wpwc_custom_registration_field_'.$key, sprintf(esc_html__('%s is required!', 'wpwc-registration' ), $field['label']) );
					}
					if($field['type'] == 'file' && $field['required']==true && (!isset($_FILES['wpwc_custom_registration_field_'.$key]) || $_FILES['wpwc_custom_registration_field_'.$key]['error']==UPLOAD_ERR_NO_FILE)){
						$validation_errors->add('wpwc_custom_registration_field_'.$key, sprintf(esc_html__('%s is required!', 'wpwc-registration' ),$field['label']) );
					}
				}
			}
			if ( get_option('wpwc_enable_user_role_field')=='yes' && !empty($_POST['wpwc_user_role']) ) {
				$available_roles = get_option('wpwc_user_role_dropdown_options');
				$requested = wc_clean($_POST['wpwc_user_role']);
				if ( !empty($available_roles) && !in_array($requested, $available_roles) ) {
					$validation_errors->add('wpwc_user_role', sprintf(esc_html__('%s role is not available in the list!', 'wpwc-registration' ),$requested) );
				}
			}
		 	return $validation_errors;
		}
		public function user_register_callback($user_id){
			if(get_option('wpwc_new_user_reg_authentication')=='active'){
				update_user_meta( $user_id, 'wpwc_user_auth_status', 'active');
				do_action('wpwc_user_auth_status_changed', $user_id,'active');
			}elseif (get_option('wpwc_new_user_reg_authentication')=='disabled') {
				update_user_meta( $user_id, 'wpwc_user_auth_status', 'disabled');
				do_action('wpwc_user_auth_status_changed', $user_id,'disabled');
			}
			$data=get_option('wpwc_fields_registration_form');
			if(!empty($data)){
				foreach ($data as $key => $value) {
					if(isset($value['enable']) && $value['enable']=='yes' && isset($_POST[$key])){
						if($key=='first_name' || $key=='last_name'){
							update_user_meta( $user_id, 'billing_'.$key, sanitize_text_field($_POST[$key]));
						}
						update_user_meta( $user_id, $key, sanitize_text_field($_POST[$key]));
					}
				}
			}
			$fields=get_option('wpwc_custom_registration_fields');
			if(!function_exists('wp_handle_upload')){
                require_once(ABSPATH.'wp-admin/includes/file.php');
                require_once(ABSPATH.'wp-admin/includes/image.php');
                require_once(ABSPATH.'wp-admin/includes/media.php');
            }
			if(!empty($fields)){
				foreach ($fields as $key => $field) {
					if($field['type'] == 'file' && !empty($_FILES['wpwc_custom_registration_field_'.$key])){
						$attach_id=media_handle_upload('wpwc_custom_registration_field_'.esc_attr($key), $user_id);
						update_user_meta( $user_id, 'wpwc_custom_registration_field_'.$key, $attach_id);
					}
					if(isset($_POST['wpwc_custom_registration_field_'.$key])){
						update_user_meta( $user_id, 'wpwc_custom_registration_field_'.$key, sanitize_text_field($_POST['wpwc_custom_registration_field_'.$key]));
					}
				}
			}
			//// Role 
			if ( get_option('wpwc_enable_user_role_field')=='yes' && !empty($_POST['wpwc_user_role'])){
				global $wp_roles;
				$roles = $wp_roles->get_names();
				$available_roles = get_option('wpwc_user_role_dropdown_options');
				$requested = wc_clean($_POST['wpwc_user_role']);
				if ( isset($roles[$requested]) && !empty($available_roles) && in_array($requested, $available_roles) ) {
					update_user_meta($user_id, 'wpwc_user_requested_role', $requested);
					if(get_option('wpwc_user_role_approve_status')=='auto'){
						$user_id = wp_update_user( array( 'ID' => $user_id, 'role' => $requested ) );
						if (!is_wp_error( $user_id ) ) {
							do_action('wpwc_user_role_granted',$user_id);
						} 
					}
				}
			}
		}
		public function enqueue_scripts(){
			wp_register_style( 'wpwc-style', WPWC_REG_URL.'assets/css/frontend_style.css', '', false, 'all' );
		}
	}
	new WPWC_User_Registration_Frontend();
}