<?php

if (!defined('ABSPATH')) {

    exit; // Exit if accessed directly.

} //!defined('ABSPATH')

if(!class_exists('WPWC_User_Registration_Backend')){

	class WPWC_User_Registration_Common{

		public function __construct(){

			add_action('wpwc_user_auth_status_changed',array($this,'auth_status_changed'),10,2);

			if(get_option('wpwc_enable_grant_role_notification')=='yes'){

				add_action('wpwc_user_role_granted',array($this,'role_granted'),10,1);

			}

		}

		public function auth_status_changed($user_id,$status){

			//// allow access

			if(get_option('wpwc_enable_access_allow_notification')=='yes' && $status=='active'){

				$subject=get_option('wpwc_access_allow_notification_subject');

				$subject=!empty($subject) ? $subject : esc_html__("Login Access Activated","wpwc-registration");

				$body=get_option('wpwc_access_allow_notification_body');

				$user=get_user_by('ID', $user_id);

				if(!is_wp_error($user)){

					$sendor=get_option('blogname').' <'.get_option('admin_email') . '>';

					$headers  = "From: ".$sendor.PHP_EOL;

					$headers .= "MIME-Version: 1.0".PHP_EOL; 

					$headers .= "Content-Type: text/html; boundary=\"".md5(time())."\"";

					wp_mail( $user->user_email, $subject, $body, $headers, '' );

				}

			}

			//// Disable access

			if(get_option('wpwc_enable_access_block_notification')=='yes' && $status=='disabled'){

				$subject=get_option('wpwc_access_block_notification_subject');

				$subject=!empty($subject) ? $subject : esc_html__("Login Access Blocked","wpwc-registration");

				$body=get_option('wpwc_access_block_notification_body');

				$user=get_user_by('ID', $user_id);

				if(!is_wp_error($user)){

					$sendor=get_option('blogname') . ' <' . get_option('admin_email') . '>';

					$headers  = "From: ".$sendor.PHP_EOL;

					$headers .= "MIME-Version: 1.0".PHP_EOL; 

					$headers .= "Content-Type: text/html; boundary=\"".md5(time())."\"";

					wp_mail( $user->user_email, $subject, $body, $headers, '' );

				}

			}

		}

		public function role_granted($user_id){

			$subject=get_option('wpwc_grant_role_notification_subject');

			$subject=!empty($subject) ? $subject : esc_html__("Requested Role Has Been Granted.","wpwc-registration");

			$body=get_option('wpwc_grant_role_notification_body');

			$user=get_user_by('ID', $user_id);

			if(!is_wp_error($user)){

				$sendor=get_option('blogname') . ' <' . get_option('admin_email') . '>';

				$headers  = "From: ".$sendor.PHP_EOL;

				$headers .= "MIME-Version: 1.0".PHP_EOL; 

				$headers .= "Content-Type: text/html; boundary=\"".md5(time())."\"";

				wp_mail( $user->user_email, $subject, $body, $headers, '' );

			}

		}

	}

	new WPWC_User_Registration_Common();

}